<?php

// arrowpress_product_attribute
add_shortcode('arrowpress_product_attribute', 'arrowpress_shortcode_product_attribute');
add_action('vc_build_admin_page', 'arrowpress_load_product_attribute_shortcode');
add_action('vc_after_init', 'arrowpress_load_product_attribute_shortcode');

function arrowpress_shortcode_product_attribute($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_woo_template('arrowpress_product_attribute'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_product_attribute_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    $order_by_values = arrowpress_vc_woo_order_by();
    $order_way_values = arrowpress_vc_woo_order_way();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('Product Attribute', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_product_attribute',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array( 
			array(
                'type' => 'textfield',
                'heading' => __( 'Title', 'arrowpress-shortcodes' ),
                'param_name' => 'title',
				"admin_label" => true,
            ),
            array(
                'type' => 'textfield',
                'heading' => __( 'Product Name', 'arrowpress-shortcodes' ),
                'param_name' => 'product_name',
				"admin_label" => true,
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__('Image Product', 'arrowpress-shortcodes'),
                'param_name' => 'image',
                'value' => '',
				"admin_label" => true,
                'description' => esc_html__( 'Upload image product.', 'arrowpress-shortcodes' ),    
            ),
			array(
                "type" => "textarea_html",
                "heading" => esc_html__("Description", 'arrowpress-shortcodes'),
                "param_name" => "content",
				"admin_label" => true,
            ), 
			array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "arrowpress-shortcodes"),
                "param_name" => "btn_text",
                'value' => esc_html__( 'Add to cart', 'arrowpress-shortcodes' ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Type", 'arrowpress-shortcodes'),
                "param_name" => "btn_layout",
                'std' => 'btn_layout_1',
                'value' => array(
                    esc_html__('Button Default', 'arrowpress-shortcodes') => 'btn_layout_1',
                    esc_html__('Button Primary', 'arrowpress-shortcodes') => 'btn_layout_2',
                ),
				"description" => esc_html__( "Select button type.", "arrowpress-shortcodes" ),
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'arrowpress-shortcodes'),
                "param_name" => "link",              
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Arrowpress_Product_Attribute')) {
        class WPBakeryShortCode_Arrowpress_Product_Attribute extends WPBakeryShortCode {
        }
    }
}