<?php
$output  = $number = $first_title = $show_filter= $gallery_desc = $last_title = $item_delay =  $el_class = '';
extract(shortcode_atts(array(
    'first_title' =>'Our',
    'last_title' => 'Portfolio',
    'icon_title' => 'icon_1',
    'number' => 6,
    'cat' => '',
    'gallery_desc' => '',
    'order' => 'desc',
    'layout' => 'grid',
    'columns' => 3,
    'show_viewmore' => '',
    'show_filter' =>'yes',
    'item_delay' => 'yes',
    'el_class' => ''
), $atts));
if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
    $paged = get_query_var('page');
} else {
    $paged = 1;
}
$current_page = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
$args = array(
    'post_type' => 'gallery',
    'post_status' => 'publish',
    'ignore_sticky_posts' => 1,
    'posts_per_page' => $number,
    'paged' => $paged,
    'order' => $order,
    'orderby' => 'date',
);
$catArray = explode(',', $cat);
if ($cat){
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'gallery_cat',
            'field'    => 'term_id',
            'terms'    => $catArray,
        ),
    );
}
$taxonomy_names = get_object_taxonomies( 'gallery' );
    if ( is_array( $taxonomy_names ) && count( $taxonomy_names ) > 0  && in_array( 'gallery_cat', $taxonomy_names ) ) {
        if($cat){
            $terms = get_terms( 'gallery_cat', array(
            'parent' => $cat, 
            'hide_empty'        => true,
            ) );
        }else{
            $terms = get_terms( 'gallery_cat', array(
                'hide_empty'        => true,  
                'parent'  => 0,             
                ) );            
        }
    }
query_posts($args);
global $wp_query;
$el_class = arrowpress_shortcode_extract_class( $el_class );
$output = '<div class="our-gallery-sc ' . $el_class . '"';
$output .= '>';
ob_start();
if(isset($columns)){
   $col_class=" col-".$columns;
}
?>
<?php 
    $count_item = 0.2; 
    $animation_delay = '';
    if($item_delay) {
        $animation_delay = ' data-sr="wait '. $count_item .'s"';  
    }
    $count_item += 0.2;
?>
<?php if (have_posts()) : ?>
            <?php if($gallery_desc !='' ||$show_filter) :?>
                <div class="gallery_header">
                    <?php if($gallery_desc !=''):?>
                        <div class="gallery_desc">
                            <p><?php echo wp_kses($gallery_desc,array('p' => array()));?></p>
                        </div>
                    <?php endif;?>
                    <?php if($show_filter):?>
                        <?php if (is_array( $terms ) && count( $terms ) > 0 ) : ?>
                            <div id="options" class="gallery_filter">
                                <div id="filters" class="button-group js-radio-button-group">
                                    <div class="inline-block">
                                        <button class="is-checked btn-filter" data-filter="*"><?php echo esc_html(substr('All', 0, 1)).'.';?></button> 
                                        <div class="text_filter"><?php echo esc_html__('All','arrowpress-shortcodes'); ?></div>
                                    </div>
                                    <?php foreach ( $terms as $key => $term ) : ?> 
                                        <div class="inline-block">
                                            <button class="btn-filter" data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo esc_html(substr($term->name, 0, 1)).'.'; ?></button>
                                            <div class="text_filter"><?php echo esc_html($term->name); ?></div>
                                        </div>
                                    <?php endforeach;?>  
                                </div>
                            </div> 
                        <?php endif;?> 
                    <?php endif;?>
                </div>
            <?php endif;?> 
            <div class="tabs_sort gallery_sort">
                <div class="gallery-entries-wrap isotope clearfix <?php echo esc_attr($col_class).' gallery-'.esc_attr($layout);?>">   
                    <?php while (have_posts()) : the_post(); ?>
                        <?php if($layout == 'masonry'):?>
                            <?php get_template_part('templates/content', 'gallery-masonry'); ?>                                     
                        <?php else:?>
                            <?php get_template_part('templates/content', 'gallery-grid'); ?><?php endif;?>
                    <?php endwhile; ?>
                </div>  
            </div> 
            <?php if($show_viewmore) :?>
                <div <?php echo $animation_delay; ?> >
                    <?php if ($wp_query->max_num_pages > 1) : ?>
                        <div class="load-more text-center">
                            <a data-paged="<?php echo esc_attr($current_page) ?>" data-totalpage="<?php echo esc_attr($wp_query->max_num_pages) ?>" id="gallery-loadmore" class="btn "><?php echo esc_html__('Load More', 'arrowpress-shortcodes') ?> </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif;?>  
<?php endif;?>
<?php
    $output .= ob_get_clean();

    $output .= '</div>' . arrowpress_shortcode_end_block_comment( 'arrowpress_portfolio' ) . "\n";

    echo $output;

wp_reset_query(); ?>