<?php

// arrowpress_slider_wrap
add_shortcode('arrowpress_slider_wrap', 'arrowpress_shortcode_slider_wrap');
add_action('vc_build_admin_page', 'arrowpress_load_slider_wrap');
add_action('vc_after_init', 'arrowpress_load_slider_wrap');

function arrowpress_shortcode_slider_wrap($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_template('arrowpress_slider_wrap'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_slider_wrap() {
    $custom_class = arrowpress_vc_custom_class();
    $animation_type = arrowpress_animation_custom();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('Slider Wrap', 'arrowpress'),
        'base' => 'arrowpress_slider_wrap',
        'category' => esc_html__('ArrowPress', 'arrowpress'),
        'icon' => 'arrowpress_vc_container',
        'is_container' => true,
        'js_view' => 'VcColumnView',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "arrowpress-shortcodes"),
                "param_name" => "layout",
                'std' => 'slide',
                'value' => array(
                    esc_html__('Wrap member', 'arrowpress-shortcodes') => 'layout1',
                    esc_html__('Wrap testimonial', 'arrowpress-shortcodes') => 'layout2',
                    esc_html__('Wrap testimonial 2', 'arrowpress-shortcodes') => 'layout3',
                ),
            ), 
			array(
                "type" => "checkbox",
                "heading" => esc_html__("Auto Play", 'arrowpress-shortcodes'),
                "param_name" => "auto_play",
                'std' => 'yes',
                'value' => array(esc_html__('Yes', 'js_composer') => 'yes')
            ), 
            array(
                "type" => "checkbox",
                "heading" => esc_html__("Dots Navigation", 'arrowpress-shortcodes'),
                "param_name" => "show_dot",
                'std' => 'yes',
                'value' => array(esc_html__('Yes', 'js_composer') => 'yes')
            ), 
            array(
                "type" => "checkbox",
                "heading" => esc_html__("Navigation Arrows", 'arrowpress-shortcodes'),
                "param_name" => "show_nav",
                'std' => 'yes',
                'value' => array(esc_html__('Yes', 'js_composer') => 'yes')
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','arrowpress-shortcodes' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','arrowpress-shortcodes' ),
            )            
        )
    ) );

    if (!class_exists('WPBakeryShortCode_arrowpress_slider_wrap')) {
        class WPBakeryShortCode_arrowpress_slider_wrap extends WPBakeryShortCodesContainer {
        }
    }
}