<?php

// Arrowpress Heading
add_shortcode('arrowpress_heading', 'arrowpress_shortcode_heading');
add_action('vc_build_admin_page', 'arrowpress_load_heading_shortcode');
add_action('vc_after_init', 'arrowpress_load_heading_shortcode');

function arrowpress_shortcode_heading($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_template('arrowpress_heading'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_heading_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('Heading', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_heading',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__( "Headding style", "arrowpress-shortcodes" ),
                "param_name" => "heading_style",
                "value" => array(
                    esc_html__('Heading Style 1', 'arrowpress-shortcodes') => 'style1',
                    ),
                "description" => esc_html__( "Select heading style.", "arrowpress-shortcodes" )
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Big Heading Title", "arrowpress-shortcodes"),
                "param_name" => "big_heading_title",
                "value" => "",
                'admin_label' => true,
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Summary Title", "arrowpress-shortcodes"),
                "param_name" => "summary_title",
                "value" => "",
                'admin_label' => true,
            ),
			array(
                "type" => "textarea",
                "heading" => esc_html__("Small Heading Title", 'arrowpress-shortcodes'),
                "param_name" => "content_desc",
                "admin_label" => true,
            ), 
            array(
                "type" => "dropdown",
                "heading" => esc_html__( "Tag heading", "arrowpress-shortcodes" ),
                "param_name" => "tag_heading",
                "value" => array(
                    esc_html__('Select tag heading', 'arrowpress-shortcodes') => '',
                    esc_html__('H1', 'arrowpress-shortcodes') => 'tag-h1',
                    esc_html__('H2', 'arrowpress-shortcodes') => 'tag-h2',
                    esc_html__('H3', 'arrowpress-shortcodes') => 'tag-h3',
                    esc_html__('H4', 'arrowpress-shortcodes') => 'tag-h4',
                    esc_html__('H5', 'arrowpress-shortcodes') => 'tag-h5',
                    esc_html__('H6', 'arrowpress-shortcodes') => 'tag-h6',
                    ),
                "description" => esc_html__( "Select tag heading.", "arrowpress-shortcodes" )
            ),  
            array(
                "type" => "dropdown",
                "heading" => esc_html__( "Headding Align", "arrowpress-shortcodes" ),
                "param_name" => "heading_align",
                "value" => array(
                    esc_html__('Center', 'arrowpress-shortcodes') => 'center',
                    esc_html__('Left', 'arrowpress-shortcodes') => 'left',
                    esc_html__('Right', 'arrowpress-shortcodes') => 'right',
                    ),
                "description" => esc_html__( "Select heading align.", "arrowpress-shortcodes" )
            ),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Title Color', 'arrowpress-shortcodes' ),
				'param_name' => 'color_default',
				'description' => esc_html__( 'Select heading color.', 'arrowpress-shortcodes' ),
				'group' => 'Color'
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Summary Color', 'arrowpress-shortcodes' ),
				'param_name' => 'color_primary',
				'description' => esc_html__( 'Select title heading summary color.', 'arrowpress-shortcodes' ),
				'group' => 'Color',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Title Color', 'arrowpress-shortcodes' ),
				'param_name' => 'color_secondary',
				'description' => esc_html__( 'Select small title heading color.', 'arrowpress-shortcodes' ),
				'group' => 'Color'
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Description Color', 'arrowpress-shortcodes' ),
				'param_name' => 'color_desc',
				'description' => esc_html__( 'Select description color.', 'arrowpress-shortcodes' ),
				'group' => 'Color',
			),
			array(
                'type' => 'checkbox',
                'heading' => esc_html__("Item delay", "arrowpress-shortcodes"),
                'param_name' => 'item_delay',
                'std' => '',
                'value' => array( esc_html__( 'Yes', 'arrowpress-shortcodes' ) => 'yes' ),
				'group' => 'Animation'
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__( "Animation Type", "arrowpress-shortcodes" ),
                "param_name" => "animation_type",
                "value" => array(
					esc_html__('bounce', 'arrowpress-shortcodes') => 'bounce',
                    esc_html__('flash', 'arrowpress-shortcodes') => 'flash',
                    esc_html__('pulse', 'arrowpress-shortcodes') => 'pulse',
                    esc_html__('rubberBand', 'arrowpress-shortcodes') => 'rubberBand',
                    esc_html__('shake', 'arrowpress-shortcodes') => 'shake',
                    esc_html__('swing', 'arrowpress-shortcodes') => 'swing',
                    esc_html__('tada', 'arrowpress-shortcodes') => 'swing',
                    esc_html__('wobble', 'arrowpress-shortcodes') => 'wobble',
                    esc_html__('jello', 'arrowpress-shortcodes') => 'jello',
                    esc_html__('bounceIn', 'arrowpress-shortcodes') => 'bounceIn',
                    esc_html__('bounceInDown', 'arrowpress-shortcodes') => 'bounceInDown',
                    esc_html__('bounceInLeft', 'arrowpress-shortcodes') => 'bounceInLeft',
                    esc_html__('bounceInRight', 'arrowpress-shortcodes') => 'bounceInRight',
                    esc_html__('bounceInUp', 'arrowpress-shortcodes') => 'bounceInUp',
                    esc_html__('bounceOut', 'arrowpress-shortcodes') => 'bounceOut',
                    esc_html__('bounceOutDown', 'arrowpress-shortcodes') => 'bounceOutDown',
                    esc_html__('bounceOutLeft', 'arrowpress-shortcodes') => 'bounceOutLeft',
                    esc_html__('bounceOutRight', 'arrowpress-shortcodes') => 'bounceOutRight',
                    esc_html__('bounceOutUp', 'arrowpress-shortcodes') => 'bounceOutUp',
					esc_html__('fadeIn', 'arrowpress-shortcodes') => 'fadeIn',
                    esc_html__('fadeInDown', 'arrowpress-shortcodes') => 'fadeInDown',
                    esc_html__('fadeInDownBig', 'arrowpress-shortcodes') => 'fadeInDownBig',
                    esc_html__('fadeInLeft', 'arrowpress-shortcodes') => 'fadeInLeft',
                    esc_html__('fadeInLeftBig', 'arrowpress-shortcodes') => 'fadeInLeftBig',
                    esc_html__('fadeInRight', 'arrowpress-shortcodes') => 'fadeInRight',
                    esc_html__('fadeInUp', 'arrowpress-shortcodes') => 'fadeInUp',
                    esc_html__('fadeInUpBig', 'arrowpress-shortcodes') => 'fadeInUpBig',
                    esc_html__('fadeOut', 'arrowpress-shortcodes') => 'fadeOut',
                    esc_html__('fadeOutDown', 'arrowpress-shortcodes') => 'fadeOutDown',
                    esc_html__('fadeOutDownBig', 'arrowpress-shortcodes') => 'fadeOutDownBig',
                    esc_html__('fadeOutLeft', 'arrowpress-shortcodes') => 'fadeOutLeft',
                    esc_html__('fadeOutLeftBig', 'arrowpress-shortcodes') => 'fadeOutLeftBig',
                    esc_html__('fadeOutRight', 'arrowpress-shortcodes') => 'fadeOutRight',
                    esc_html__('fadeOutUp', 'arrowpress-shortcodes') => 'fadeOutUp',
                    esc_html__('fadeOutUpBig', 'arrowpress-shortcodes') => 'fadeOutUpBig',
                    esc_html__('flip', 'arrowpress-shortcodes') => 'flip',
                    esc_html__('flipInX', 'arrowpress-shortcodes') => 'flipInX',
                    esc_html__('flipInY', 'arrowpress-shortcodes') => 'flipInY',
                    esc_html__('flipOutX', 'arrowpress-shortcodes') => 'flipOutX',
                    esc_html__('flipOutY', 'arrowpress-shortcodes') => 'flipOutY',
                    esc_html__('lightSpeedIn', 'arrowpress-shortcodes') => 'lightSpeedIn',
                    esc_html__('lightSpeedOut', 'arrowpress-shortcodes') => 'lightSpeedOut',
                    esc_html__('rotateIn', 'arrowpress-shortcodes') => 'rotateIn',
                    esc_html__('rotateInDownLeft', 'arrowpress-shortcodes') => 'rotateInDownLeft',
                    esc_html__('rotateInDownRight', 'arrowpress-shortcodes') => 'rotateInDownRight',
                    esc_html__('rotateInUpLeft', 'arrowpress-shortcodes') => 'rotateInUpLeft',
                    esc_html__('rotateInUpRight', 'arrowpress-shortcodes') => 'rotateInUpRight',
                    esc_html__('rotateOut', 'arrowpress-shortcodes') => 'rotateOut',
                    esc_html__('rotateOutDownLeft', 'arrowpress-shortcodes') => 'rotateOutDownLeft',
                    esc_html__('rotateOutDownRight', 'arrowpress-shortcodes') => 'rotateOutDownRight',
                    esc_html__('rotateOutUpLeft', 'arrowpress-shortcodes') => 'rotateOutUpLeft',
                    esc_html__('rotateOutUpRight', 'arrowpress-shortcodes') => 'rotateOutUpRight',
                    esc_html__('slideInUp', 'arrowpress-shortcodes') => 'slideInUp',
                    esc_html__('slideInDown', 'arrowpress-shortcodes') => 'slideInDown',
                    esc_html__('slideInLeft', 'arrowpress-shortcodes') => 'slideInLeft',
                    esc_html__('slideInRight', 'arrowpress-shortcodes') => 'slideInRight',
                    esc_html__('slideOutUp', 'arrowpress-shortcodes') => 'slideOutUp',
                    esc_html__('zoomIn', 'arrowpress-shortcodes') => 'zoomIn',
                    esc_html__('zoomInRight', 'arrowpress-shortcodes') => 'zoomInRight',
                    esc_html__('zoomInUp', 'arrowpress-shortcodes') => 'zoomInUp',
                    esc_html__('zoomOut', 'arrowpress-shortcodes') => 'zoomOut',
                    esc_html__('zoomOutDown', 'arrowpress-shortcodes') => 'zoomOutDown',
                    esc_html__('zoomOutLeft', 'arrowpress-shortcodes') => 'zoomOutLeft',
                    esc_html__('zoomOutRight', 'arrowpress-shortcodes') => 'zoomOutRight',
                    esc_html__('zoomOutUp', 'arrowpress-shortcodes') => 'zoomOutUp',
                    esc_html__('hinge', 'arrowpress-shortcodes') => 'hinge',
                    esc_html__('rollIn', 'arrowpress-shortcodes') => 'rollIn',
                    esc_html__('rollOut', 'arrowpress-shortcodes') => 'rollOut',
                    ),
                "description" => esc_html__( "Select Animation Style.", "arrowpress-shortcodes" ),
				'group' => 'Animation'
            ),
			array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Animation Delay", "arrowpress-shortcodes"),
				"description" => esc_html__( "Enter Animation Delay.", "arrowpress-shortcodes" ),
                "param_name" => "animation_delay",
                "value" => 500,
                'admin_label' => true,
				'group' => 'Animation'
            ),
            // vc_map_add_css_animation(),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'arrowpress-shortcodes' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'arrowpress-shortcodes' ),
            ),
        )
    ) );
    if (!class_exists('WPBakeryShortCode_arrowpress_Heading')) {
        class WPBakeryShortCode_arrowpress_Heading extends WPBakeryShortCode {
        }
    }
}