<?php

class ArrowPressPostTypes {

    function __construct() {
        // Register post types
    add_action('init', array($this, 'addBlockPostType'));
    add_action('init', array($this, 'addGalleryPostType'));
    
    }            
    // Register static block post type
    function addBlockPostType() {
        register_post_type(
            'block', array(
            'labels' => $this->getLabels(esc_html__('Static Block', 'arrowpress-shortcodes'), esc_html__('Static Block', 'arrowpress-shortcodes')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'block'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
    // Register Gallery post type
    function addGalleryPostType() {
        global $mokar_settings;
        if(isset($mokar_settings['gallery_slug'])){
            $gallery_slug = $mokar_settings['gallery_slug'];
        }
        else {$gallery_slug = "gallery"; }
        if(isset($mokar_settings['gallery_cat_slug'])){
            $gallery_cat_slug = $mokar_settings['gallery_cat_slug'];
        }
        else {$gallery_cat_slug = "gallery_cat"; }                 
        register_post_type(
            'gallery', array(
            'labels' => $this->getLabels(esc_html__('Gallery', 'arrowpress-shortcodes'), esc_html__('Galleries', 'arrowpress-shortcodes')),
            'exclude_from_search' => false,
            'has_archive' => true,
            // 'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => $gallery_slug),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
            )
        );
        register_taxonomy(
            'gallery_cat', 'gallery', array(
            'hierarchical' => true,
            'show_in_nav_menus' => true,
            'labels' => $this->getTaxonomyLabels(esc_html__('Gallery Category', 'arrowpress-shortcodes'), esc_html__('Gallery Categories', 'arrowpress-shortcodes')),
            'query_var' => true,
            'rewrite' => array('slug' => $gallery_cat_slug),
                )
        );
    }
    // Get content type labels
    function getLabels($singular_name, $name, $title = FALSE) {
        if (!$title)
            $title = $name;

        return array(
            "name" => $title,
            "singular_name" => $singular_name,
            "add_new" => esc_html__("Add New", 'arrowpress-shortcodes'),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'arrowpress-shortcodes'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %s", 'arrowpress-shortcodes'), $singular_name),
            "new_item" => sprintf(esc_html__("New %s", 'arrowpress-shortcodes'), $singular_name),
            "view_item" => sprintf(esc_html__("View %s", 'arrowpress-shortcodes'), $singular_name),
            "search_items" => sprintf(esc_html__("Search %s", 'arrowpress-shortcodes'), $name),
            "not_found" => sprintf(esc_html__("No %s found", 'arrowpress-shortcodes'), $name),
            "not_found_in_trash" => sprintf(esc_html__("No %s found in Trash", 'arrowpress-shortcodes'), $name),
            "parent_item_colon" => ""
        );
    }

    // Get content type taxonomy labels
    function getTaxonomyLabels($singular_name, $name) {
        return array(
            "name" => $name,
            "singular_name" => $singular_name,
            "search_items" => sprintf(esc_html__("Search %s", 'arrowpress-shortcodes'), $name),
            "all_items" => sprintf(esc_html__("All %s", 'arrowpress-shortcodes'), $name),
            "parent_item" => sprintf(esc_html__("Parent %s", 'arrowpress-shortcodes'), $singular_name),
            "parent_item_colon" => sprintf(esc_html__("Parent %s:", 'arrowpress-shortcodes'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %", 'arrowpress-shortcodes'), $singular_name),
            "update_item" => sprintf(esc_html__("Update %s", 'arrowpress-shortcodes'), $singular_name),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'arrowpress-shortcodes'), $singular_name),
            "new_item_name" => sprintf(esc_html__("New %s Name", 'arrowpress-shortcodes'), $singular_name),
            "menu_name" => $name,
        );
    }

}

new ArrowPressPostTypes();