@extends('index')
@section('meta-content')
	<meta name="twitter:card" value="photo"/>
	<meta name="twitter:site" value="{{ '@'.$settings->twitter_page_id }}"/>
	<meta property="og:type" content="article" />
	<meta property="og:site_name" content="{{ $settings->website_name }}"/>
	<meta property="og:url" content="{{ Request::url() }}"/>
	<meta property="og:title" content="{{ Lang::get('words.download') }} {{ $title }} {{ Lang::get('words.tracks') }}"/>
	<meta property="og:description" content="{{ Lang::get('words.download') }} {{ $title }} {{ Lang::get('words.tracks') }}"/>
	<title>{{ Lang::get('words.download') }} {{ $title }} {{ Lang::get('words.tracks') }}</title>
@stop
@if(isset($youtubeID))
	@section('youtube')
	<iframe width="300" height="300" src="//www.youtube.com/embed/{{ $youtubeID }}" frameborder="0" allowfullscreen></iframe>
	@stop
@endif
@section('content')
<?php
	$downloadLink = '';
	if($settings->downloadable) {
		$downloadLink = '<button title="'.Lang::get("words.download").'" class="btn btn-transparent btn-circle track-download"><span class="fa fa-download"></span></button>';
	}
?>

<div class="row bg-transparent">
	@if(isset($youtubeID))<div class="transparent-img" style="background-image:url('https://i1.ytimg.com/vi/{{ $youtubeID }}/mqdefault.jpg')"></div>@endif
	<div class="album-header hidden-xs">
		<div class="text-center">
			<iframe src="{{ URL::to('ads/banner') }}" width='728' height='90' frameborder='0' border='0' marginwidth='0' marginheight='0' scrolling='no'></iframe>
		</div>
		<h2 style="margin-bottom:0" class="text-muted">{{ Lang::get('words.search') }} {{ $title }}</h2>
	</div>
	@if(count($tracks))
		<div class="table-responsive">
			<table class="table album-tracks">
				<thead>
					<tr>
						<th>{{ Lang::get('words.title') }}</th>
						<th class="hidden-480">{{ Lang::get('words.size') }}</th>
						<th class="hidden-480">{{ Lang::get('words.duration') }}</th>
						<th class="text-center">{{ Lang::get('words.actions') }}</th>
					</tr>
				</thead>
				<tbody class="scroll-container">
				@foreach($tracks as $track)
					<?php 
					$sharelink = URL::to('track/'.htmlspecialchars($track['title']).'/'.$track['id']);
					?>
					<tr class="scroll-items" data-title="{{ $track['title'] }}" data-share="{{ $sharelink }}" data-trackid="{{ $track['id'] }}">
						<td>
							<img class="pull-left elemWidth" style="width:30px; height:30px; margin-right:10px" src="{{ $track['image'] }}">
							<button class="btn btn-transparent btn-circle pull-left track-play-list elemWidth">
								<span class="fa fa-play"></span>
							</button>
							<div class="track-album pull-left" title="{{ $track['title'] }}">
								<a class="tt-title pjax" title="{{ $track['title'] }}" href="{{ $sharelink }}">{{ htmlspecialchars($track['title']) }}</a>
								<span class="pull-left text-muted">{{ Lang::get('words.owner') }}: <a class="album-artist" title="{{ $track['username'] }}" target="_blank" style="margin:0; display:inline" href="https://soundcloud.com/{{ $track['username-slug'] }}">{{ $track['username'] }}</a></span>
							</div>
							<div class="clearfix"></div>
						</td>
						<td class="hidden-480 elemWidth">
							{{ Custom::formatBytes($track['size']) }}
						</td>
						<td class="hidden-480 elemWidth">
							{{ Custom::formatMilliseconds($track['duration']) }}
						</td>
						<td class="text-center elemWidth">
							{{ $downloadLink }}
							<button title="{{ Lang::get('words.add-to-playlist') }}" class="btn btn-transparent btn-circle" data-toggle="modal" data-target="#track-playlist-modal"><span class="fa fa-plus"></span></button>
							<button title="{{ Lang::get('words.share') }}" class="btn btn-transparent btn-circle" data-toggle="modal" data-target="#social-share-modal"><span class="fa fa-share-alt"></span></button>
						</td>
					</tr>
				@endforeach
				</tbody>
			</table>
			{{ $pagination }}
		</div>
	@else
		<div class="col-xs-12">
			<div class="alert alert-danger"><i class="fa fa-meh-o"></i> Sorry, No Tracks found</div>
		</div>
	@endif
</div>

@if(!Auth::guest())

<?php $playlists = Playlist::where('user_id', Auth::user()->id)->select(array('id','title'))->take(50)->get(); ?>
<div class="modal fade" id="track-playlist-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
	<div class="modal-dialog">
    	<div class="modal-content">
      		<div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">{{ Lang::get('words.add-to-playlist') }}</h4>
      		</div>
      		<form id="track-playlist-form" role="form" method="post" action="{{ URL::to('user/playlist/track/add') }}">
	      		<div class="modal-body">
			    	<input type="hidden" name="_token" value="{{ csrf_token() }}">
			    	<input type="hidden" name="trackid" value="">
			    	<input type="hidden" name="title" value="">
		            <div class="funkyradio" style="height:320px; overflow-y:scroll">
		            	@foreach($playlists as $i => $playlistm)
		            		<div class="funkyradio-success">
					            <input type="radio" name="playlist" value="{{ $playlistm->id }}" id="radio{{ $i }}" />
					            <label for="radio{{ $i }}">{{ $playlistm->title }}</label>
					        </div>
		            	@endforeach
		            </div>
	      		</div>
	      		<div class="modal-footer">
	        		<input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.add-track') }}">
	      		</div>
	      	</form>
    	</div>
	</div>
</div>
@endif

<div class="modal fade" id="social-share-modal" tabindex="-1" role="dialog" aria-labelledby="social-share-modalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="social-share-modalLabel"><i class="fa fa-share-alt"></i> {{ Lang::get('words.share') }}</h4>
      </div>
      <div class="modal-body">
    	<div class="ft-social text-center">
			<a target="_blank" title="Share" class="btn btn-circle bg-facebook"><span class="fa fa-facebook"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-twitter"><span class="fa fa-twitter"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-google"><span class="fa fa-google-plus"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-linkedin"><span class="fa fa-linkedin"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-digg"><span class="fa fa-digg"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-stumble"><span class="fa fa-stumbleupon"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-pinterest"><span class="fa fa-pinterest"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-vk"><span class="fa fa-vk"></span></a>
		</div>
      </div>
    </div>
  </div>
</div>

@stop