@extends('index')
@section('meta-content')
	<meta name="twitter:card" value="photo"/>
	<meta name="twitter:site" value="{{ '@'.$settings->twitter_page_id }}"/>
	<meta name="twitter:image" value="{{ URL::asset('assets/images/logo.png') }}"/>
	<meta property="og:type" content="blog"/>
	<meta property="og:site_name" content="{{ $settings->website_name }}"/>
	<meta property="og:url" content="{{ Request::url() }}"/>
	<meta property="og:title" content="{{ Lang::get('words.playlist') }}: {{ $playlist->title }}"/>
	<meta property="og:image" content="{{ URL::asset('assets/images/logo.png') }}"/>
	<meta property="og:description" content="{{ $settings->website_name }} - {{ Lang::get('words.playlist') }}: {{ $playlist->title }}"/>
	<title>{{ Lang::get('words.playlist') }}: {{ $playlist->title }}</title>
@stop

@section('content')
<?php
	$tracks = $playlist->tracks()->paginate(20);

	$downloadLink = '';
	if($settings->downloadable) {
		$downloadLink = '<button title="'.Lang::get("words.download").'" class="btn btn-transparent btn-circle track-download"><span class="fa fa-download"></span></button>';
	}
?>
<div class="row bg-transparent">
	<div class="transparent-img"></div>
	<div class="album-header">
		<div class="text-center" style="margin-bottom:15px">
			<iframe src="{{ URL::to('ads/banner') }}" width='728' height='90' frameborder='0' border='0' marginwidth='0' marginheight='0' scrolling='no'></iframe>
		</div>

		<h2 class="text-muted pull-left" style="margin:0">{{ $playlist->title }} ({{ $playlist->tracksCount() }})</h2>
		<div class="pull-right">
			<button class="btn btn-labeled btn-primary" data-toggle="modal" data-target="#edit-playlist-modal"><span class="btn-label"><i class="fa fa-edit"></i></span> {{ Lang::get('words.edit') }}</button>
					&nbsp;&nbsp;&nbsp;&nbsp;
			<button class="btn btn-labeled btn-danger" data-toggle="modal" data-target="#rm-playlist-modal"><span class="btn-label"><i class="fa fa-trash"></i></span> {{ Lang::get('words.delete') }}</button>
		</div>
		<div class="clearfix"></div>
	</div>
	<div class="table-responsive">
		<table class="table album-tracks">
			<thead>
				<tr>
					<th>{{ Lang::get('words.title') }}</th>
					<th class="text-center">{{ Lang::get('words.actions') }}</th>
				</tr>
			</thead>
			<tbody class="scroll-container">
			@foreach($tracks as $track)
				<?php 
				$sharelink = URL::to('track/'.htmlspecialchars($track->title).'/'.$track->track_id.'/0');
				?>
				<tr class="scroll-items" data-title="{{ $track->title }}" data-share="{{ $sharelink }}" data-id="{{ $track->id }}" data-trackid="{{ $track->track_id }}">
					<td>
						<button class="btn btn-transparent btn-circle pull-left track-play-list elemWidth">
							<span class="fa fa-play"></span>
						</button>
						<div class="track-album pull-left">
							{{ htmlspecialchars_decode($track->title) }}
						</div>
						<div class="clearfix"></div>
					</td>
					<td class="text-center elemWidth">
						{{ $downloadLink }}
						<button title="{{ Lang::get('words.add-to-playlist') }}" class="btn btn-transparent btn-circle" data-toggle="modal" data-target="#track-playlist-modal"><span class="fa fa-plus"></span></button>
						<button title="{{ Lang::get('words.remove-track') }}" class="btn btn-transparent btn-circle" data-toggle="modal" data-target="#rm-track-modal"><span class="fa fa-trash"></span></button>
						<button title="{{ Lang::get('words.share') }}" class="btn btn-transparent btn-circle" data-toggle="modal" data-target="#social-share-modal"><span class="fa fa-share-alt"></span></button>
					</td>
				</tr>
			@endforeach
			</tbody>
		</table>
	</div>
	{{ $tracks->links('pagination::simple') }}
</div>

<div class="modal fade" id="rm-playlist-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
	<div class="modal-dialog">
    	<div class="modal-content">
      		<div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">{{ Lang::get('words.delete-playlist') }}</h4>
      		</div>
      		<form id="rm-playlist-form" role="form" method="post" action="{{ URL::to('user/playlist/'.$playlist->slug.'/delete') }}">
	      		<div class="modal-body">
			    	<input type="hidden" name="_token" value="{{ csrf_token() }}">
			    	<h5>{{ Lang::get('words.delete-playlist-msg') }}</h5>
	      		</div>
	      		<div class="modal-footer">
	        		<input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.delete-playlist') }}">
	      		</div>
	      	</form>
    	</div>
	</div>
</div>
<div class="modal fade" id="rm-track-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
	<div class="modal-dialog">
    	<div class="modal-content">
      		<div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">{{ Lang::get('words.remove-track') }}</h4>
      		</div>
      		<form id="rm-track-form" role="form" method="post" action="{{ URL::to('user/playlist/'.$playlist->id.'/track/remove') }}">
	      		<div class="modal-body">
			    	<input type="hidden" name="_token" value="{{ csrf_token() }}">
			    	<input type="hidden" name="playlist" value="{{ $playlist->slug }}">
			    	<input type="hidden" name="track" value="">
			    	<h5>{{ Lang::get('words.remove-track-msg') }}</h5>
	      		</div>
	      		<div class="modal-footer">
	        		<input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.remove-track') }}">
	      		</div>
	      	</form>
    	</div>
	</div>
</div>
<div class="modal fade" id="edit-playlist-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
	<div class="modal-dialog">
    	<div class="modal-content">
      		<div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">{{ Lang::get('words.edit-playlist') }}</h4>
      		</div>
      		<form id="edit-playlist-form" role="form" method="post" action="{{ URL::to('user/playlist/'.$playlist->slug.'/edit') }}">
	      		<div class="modal-body">
			    	<input type="hidden" name="_token" value="{{ csrf_token() }}">
			    	<div class="form-group">
			    		<label>{{ Lang::get('words.title') }}: </label>
			    		<input type="text" placeholder="{{ Lang::get('words.title') }}" class="form-control" value="{{ $playlist->title }}" name="title">
			    	</div>		            
	      		</div>
	      		<div class="modal-footer">
	        		<input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.save-playlist') }}">
	      		</div>
	      	</form>
    	</div>
	</div>
</div>
<?php $playlists = Playlist::where('user_id', Auth::user()->id)->select(array('id','title'))->take(50)->get(); ?>
<div class="modal fade" id="track-playlist-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
	<div class="modal-dialog">
    	<div class="modal-content">
      		<div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">{{ Lang::get('words.add-to-playlist') }}</h4>
      		</div>
      		<form id="track-playlist-form" role="form" method="post" action="{{ URL::to('user/playlist/track/add') }}">
	      		<div class="modal-body">
			    	<input type="hidden" name="_token" value="{{ csrf_token() }}">
			    	<input type="hidden" name="trackid" value="">
			    	<input type="hidden" name="ttitle" value="">
		            <div class="funkyradio" style="height:320px; overflow-y:scroll">
		            	@foreach($playlists as $i => $playlistm)
		            		<div class="funkyradio-success">
					            <input type="radio" name="playlist" value="{{ $playlistm->id }}" id="radio{{ $i }}" />
					            <label for="radio{{ $i }}">{{ $playlistm->title }}</label>
					        </div>
		            	@endforeach
		            </div>
	      		</div>
	      		<div class="modal-footer">
	        		<input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.add-track') }}">
	      		</div>
	      	</form>
    	</div>
	</div>
</div>
<div class="modal fade" id="social-share-modal" tabindex="-1" role="dialog" aria-labelledby="social-share-modalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="social-share-modalLabel"><i class="fa fa-share-alt"></i> {{ Lang::get('words.share') }}</h4>
      </div>
      <div class="modal-body">
    	<div class="ft-social text-center">
			<a target="_blank" title="Share" class="btn btn-circle bg-facebook"><span class="fa fa-facebook"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-twitter"><span class="fa fa-twitter"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-google"><span class="fa fa-google-plus"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-linkedin"><span class="fa fa-linkedin"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-digg"><span class="fa fa-digg"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-stumble"><span class="fa fa-stumbleupon"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-pinterest"><span class="fa fa-pinterest"></span></a>
			<a target="_blank" title="Share" class="btn btn-circle bg-vk"><span class="fa fa-vk"></span></a>
		</div>
      </div>
    </div>
  </div>
</div>
@stop