<!doctype html>
<html lang="en">
<head>
	<?php
		$languages = App::make('LanguageController')->all();
	?>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
	@yield('meta-content')
	<meta name="rootURL" content="{{ URL::to('/') }}">
	<meta name="_token" content="{{ csrf_token() }}">
	<meta name="auth_download" content="{{ $settings->auth_download }}">
	<meta name="is_login" content="@if(Auth::guest()) 0 @else 1 @endif">
	<meta name="soundcloud_key" content="{{ $settings->soundcloud_key }}">

	<link rel="stylesheet" href="{{ URL::asset('assets/css/bootstrap.css') }}" />
	<link rel="stylesheet" href="{{ URL::asset('assets/css/font-awesome.css') }}" />
	<link rel="stylesheet" href="{{ URL::asset('assets/css/bar-ui.css') }}" />
    <link rel="stylesheet" href="{{ URL::asset('assets/css/style.css?v=2') }}" />

    <link rel="icon" href="{{ URL::asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <link rel="shortcut icon" href="{{ URL::asset('assets/images/favicon.ico') }}" type="image/x-icon">

    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery-1.11.0.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/bootstrap.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jscroll.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.form.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.pjax.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/typeahead.bundle.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/nprogress.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.noty.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/soundmanager2.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/bar-ui.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery-ui.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/app.js?v=2') }}"></script>
    <script type="text/javascript">
      $(document).ready(function(){
        rootURL = "{{ URL::to('/') }}";
      });
    </script>
    <style type="text/css">
    	.side-nav>li.active>a, .navbar-inverse .navbar-nav > li > a:hover, .navbar-inverse .navbar-nav > li > a:focus {
		    border-left-color: {{ $settings->theme_color }};
		}
		.fav-link.active {
		  border-bottom: 3px solid {{ $settings->theme_color }};
		}
		.create-playlist, .create-playlist:hover, .create-playlist:focus, .album-like.active, .track-like.active {
		    color: {{ $settings->theme_color }};
		}
		.navbar-inverse .navbar-toggle .icon-bar, #nprogress .bar, .more-gl.dropdown-menu > li > a:hover {
		    background-color: {{ $settings->theme_color }};
		}
		#nprogress .peg {
		  box-shadow: 0 0 10px {{ $settings->theme_color }}, 0 0 5px{{ $settings->theme_color }};
		}
		#nprogress .spinner-icon {
		  border-top-color: {{ $settings->theme_color }};
		  border-left-color: {{ $settings->theme_color }};
		}
		.pager>li>span, .pager>.active>span, .pager>li>a:hover, .pager>.active>span:hover, .pager>li>span:hover, .pager>.disabled>span, .pager>.disabled>span:hover, .pager>li>a, .profile-header {
            background-color: {{ $settings->theme_color }};
        }
        .pager>li>span:hover, .pager>.disabled>span, .pager>.disabled>span:hover, .genre-list > li:last-child .fa{
            color:{{ $settings->theme_color }};
        }
        .pager>li>a, .pager > .disabled > span{
            border:1px solid {{ $settings->theme_color }};
        }
    </style>
</head>
<body>
<div id="fb-root"></div>
<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
	<button data-direction="left" data-target="#slidemenu" class="navbar-toggle" type="button">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
	</button>
	<div class="col-sm-9">
		<div class="sm2-bar-ui full-width pull-left">
	        <div class="bd sm2-main-controls">
	        	<div class="sm2-inline-element">
	                <a class="navbar-brand logo hidden-xs pjax" title="{{ $settings->website_name }}" href="{{ URL::to('/') }}"><img alt="{{ $settings->website_name }}" src="{{ URL::asset('assets/images/logo.png') }}"/></a>
	            </div>
	        	<div class="sm2-inline-element sm2-button-element">
	                <div class="sm2-button-bd">
	                	<a class="sm2-inline-button previous" title="Previous" href="#prev">&lt; previous</a>
	                </div>
	            </div>

	            <div class="sm2-inline-element sm2-button-element">
	                <div class="sm2-button-bd">
	                    <a id="play-pause" class="sm2-inline-button play-pause" href="#play">Play / pause</a>
	                </div>
	            </div>

	            <div class="sm2-inline-element sm2-button-element">
	                <div class="sm2-button-bd">
	                    <a id="play-next" class="sm2-inline-button next" title="Next" href="#next">&gt; next</a>
	                </div>
	            </div>

	            <div class="sm2-inline-element sm2-inline-status">
	                
	                <div class="sm2-progress">
	                    <div class="sm2-row">
	                        <div class="sm2-inline-time">0:00</div>
	                        <div class="sm2-progress-bd">
	                            <div class="sm2-progress-track">
	                            <div class="sm2-progress-bar"></div>
	                                <div class="sm2-progress-ball">
	                                    <div class="icon-overlay"></div>
	                                </div>
	                            </div>
	                        </div>
	                        <div class="sm2-inline-duration">0:00</div>
	                    </div>
	                </div>

	            </div>

	            <div class="sm2-inline-element sm2-button-element sm2-volume">
	                <div class="sm2-button-bd">
	                    <span class="sm2-inline-button sm2-volume-control volume-shade"></span>
	                    <a class="sm2-inline-button sm2-volume-control" href="#volume">volume</a>
	                </div>
	            </div>

	            <div class="sm2-inline-element sm2-button-element sm2-menu">
	                <div class="sm2-button-bd">
	                    <a class="sm2-inline-button menu" href="#menu">menu</a>
	                </div>
	            </div>
	           
	        </div>
	        
	        <div class="bd sm2-playlist-drawer sm2-element" style="height: 0px;">

	            <div class="sm2-inline-texture">
	                <div class="sm2-box-shadow"></div>
	            </div>

	            <!-- playlist content is mirrored here -->
	            <div class="sm2-playlist-wrapper">            
	                <ul class="sm2-playlist-bd">
	                    <li></li>
	                </ul>
	            </div>

	        </div>
	    </div>
	</div>
	<div class="col-sm-3 hidden-xs">
    <form class="navbar-form padding0" role="search" method="get" action="{{ URL::to('/') }}">
			        <div class="form-group form-addon">
			        	<span class="fa fa-search"></span>
			        	<input type="text" name="q" class="form-control typeahead6 form-addon" placeholder="{{ Lang::get('words.search') }}">
			        </div>
			    </form>
	</div>
</nav>
<div id="wrapper" class="hidden">
	<nav class="navbar-inverse">
		<ul class="nav navbar-nav side-nav" id="slidemenu">
	        <li @if(Request::is('/')) class="active" @endif>
	            <a class="pjax" href="{{ URL::to('/') }}"><i class="fa fa-2x fa-home"></i> {{ Lang::get('words.home') }}</a>
	        </li>
	        <li @if(Request::is('user/playlist')) class="active" @endif>
	            <a @if(Auth::guest()) data-target="#signup" data-toggle="modal" @else class="pjax" @endif href="{{ URL::to('user/playlist') }}"><i class="fa fa-2x fa-music"></i> {{ Lang::get('words.playlist') }}</a>
	        </li>
	        @if(!Auth::guest())
	        	<li @if(Request::is('settings')) class="active" @endif>
		            <a class="pjax" href="{{ URL::to('user/settings') }}"><i class="fa fa-2x fa-gear"></i> {{ Lang::get('words.settings') }}</a>
		        </li>
		        <li>
		            <a class="pjax" href="{{ URL::to('user/logout') }}"><i class="fa fa-2x fa-power-off"></i> {{ Lang::get('words.logout') }}</a>
		        </li>
		        @if(Auth::user()->admin)
			        <li>
			            <a href="{{ URL::to('user/admin') }}"><i class="fa fa-2x fa-dashboard"></i> {{ Lang::get('words.admin') }}</a>
			        </li>
	        	@endif
	        @else
		        <li>
		            <a data-toggle="modal" data-target="#signup" href="#signup"><i class="fa fa-2x fa-sign-in"></i> {{ Lang::get('words.login') }}</a>
		        </li>
	        @endif
	    </ul>
	    <div class="ad-nav hidden-sm hidden-xs">
	    	<div style="margin:7px auto; width:300px;">
	    		@yield('youtube')
	    		<br />
	    		<iframe src="{{ URL::to('ads/box') }}" width='300' height="250" frameborder='0' border='0' marginwidth='0' marginheight='0' scrolling='no'></iframe>
	    		<br>
	    		<iframe src="{{ URL::to('ads/box') }}" width='300' height="250" frameborder='0' border='0' marginwidth='0' marginheight='0' scrolling='no'></iframe>
	    	</div>
	    </div>
	</nav>
	<div id="page-wrapper">
		<div class="container-fluid">
			<div class="col-xs-12">
			    <form class="navbar-form padding0 visible-xs" role="search" method="get" action="{{ URL::to('/') }}">
			        <div class="form-group form-addon">
			        	<span class="fa fa-search"></span>
			        	<input type="text" name="q" class="form-control typeahead6 form-addon" placeholder="{{ Lang::get('words.search') }}">
			        </div>
			    </form>
			    <ul class="genre-list">
				@foreach($genres as $i => $genre)
					@if($i == 0)
			        	<li class="li-show"><a href="{{ URL::to($genre->name) }}" class="pjax @if(Request::is('/') || Request::is($genre->name)) active @endif">{{ $genre->name }}</a></li>
			        @else
			        	<li class="li-show"><a href="{{ URL::to($genre->name) }}" class="pjax @if(Request::is($genre->name)) active @endif">{{ $genre->name }}</a></li>
			        @endif
			    @endforeach
			        <li class="dropdown" role="presentation">
			            <a class="dropdown-toggle" data-toggle="dropdown" role="button" href="">{{ Lang::get('words.more') }} <span class="fa fa-caret-down"></span></a>
			            <ul id="more-gl" class="dropdown-menu more-gl" role="menu"></ul>
			        </li>
			        <li class="dropdown" role="presentation">
			            <a class="dropdown-toggle" data-toggle="dropdown" role="button" href=""><img height="16px" src="{{ URL::asset('assets/flags/'.App::getLocale().'.png') }}"><span class="caret"></span></a>
			            <ul class="dropdown-menu more-gl" role="menu">
			            	@foreach($languages as $language => $nativeName)
								<li><a title="{{ $nativeName }}" href="{{ URL::to('/language/'.$language) }}"><img alt="{{ $nativeName }}" src="{{ URL::asset('assets/flags/'.$language.'.png') }}"> {{ $nativeName }}</a></li>
							@endforeach
			            </ul>
			        </li>
			    </ul>
				@yield('content')
				<div class="clearfix"></div>
				<div class="row" id="footer-category">
					<div class="col-sm-9 text-center">
						<div id="footer-links">
							<a class="pjax" title="{{ Lang::get('words.terms') }}" href="{{ URL::to('page/terms') }}">{{ Lang::get('words.terms') }}</a>
							<a class="pjax" title="{{ Lang::get('words.privacy') }}" href="{{ URL::to('page/privacy') }}">{{ Lang::get('words.privacy') }}</a>
							<a class="pjax" title="{{ Lang::get('words.faq') }}" href="{{ URL::to('page/faq') }}">{{ Lang::get('words.faq') }}</a>
							<a class="pjax" title="{{ Lang::get('words.contact') }}" href="{{ URL::to('page/contact') }}">{{ Lang::get('words.contact') }}</a>
						</div>
						<h6 class="text-muted">
							&copy; {{ $settings->website_name }} {{ date('Y') }} , {{ Lang::get('words.all-rights-reserved') }}
						</h6>
					</div>
					<div class="col-sm-3">
						<div class="ft-social">
							<span>{{ Lang::get('words.follow-us') }}:</span>
							<a class="btn btn-circle bg-facebook" title="" href="https://facebook.com/{{ $settings->fb_page_id }}"><span class="fa fa-facebook"></span></a>
							<a class="btn btn-circle bg-twitter" title="" href="https://twitter.com/{{ $settings->twitter_page_id }}"><span class="fa fa-twitter"></span></a>
							<a class="btn btn-circle bg-google" title="" href="https://plus.google.com/{{ $settings->google_page_id }}"><span class="fa fa-google-plus"></span></a>
						</div>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
	</div>
</div>

@include('modals.modal-form')
<script type="text/javascript">
 	@if(Session::get('message') != '' && Session::get('status') != '')
        var n = noty({
                text        : '{{ Session::get("message") }}',
                type        : '{{ Session::get("status") }}',
                dismissQueue: true,
                layout      : 'bottomRight',
                closeWith   : ['click'],
                theme       : 'relax',
                maxVisible  : 10
            });
        <?php Session::forget('status'); Session::forget('message'); ?>
    @endif
</script>
@if(isset($settings->analytics))
  	{{ htmlspecialchars_decode($settings->analytics) }}
@endif
</body>
</html>