@extends('index')
@section('meta-content')
	<meta name="twitter:card" value="photo"/>
	<meta name="twitter:site" value="{{ '@'.$settings->twitter_page_id }}"/>
	<meta name="twitter:image" value="{{ URL::asset('assets/images/logo.png') }}"/>
	<meta property="og:type" content="blog"/>
	<meta property="og:site_name" content="{{ $settings->website_name }}"/>
	<meta property="og:url" content="{{ URL::to('/') }}"/>
	<meta property="og:title" content="{{ $settings->website_name }} - {{ $settings->website_title }}"/>
	<meta property="og:image" content="{{ URL::asset('assets/images/logo.png') }}"/>
	<meta property="og:description" content="{{ $settings->website_name }} {{ $settings->website_description }}"/>
	<title>{{ $settings->website_name }} - {{ $settings->website_title }}</title>
@stop

@section('content')
	@foreach($songs as $song)
    	<div class="col-lg-2 col-md-3 col-sm-4 col-xs-4" style="padding:0; margin:15px 0">
        	<div class="album">
            	<a class="pjax" title="{{ $song['title'] }}" href="{{ URL::to('search/'.htmlspecialchars($song['title'])) }}"><img width="170px" height="170px" src="{{ $song['image'] }}" alt="{{ $song['title'] }}"></a>
            	<div class="album-info">
            		<a class="album-title pjax" title="{{ htmlspecialchars($song['title']) }}" href="{{ URL::to('search/'.htmlspecialchars($song['title'])) }}">{{ htmlspecialchars($song['title']) }}</a>
            		<a class="album-artist pjax" title="{{ htmlspecialchars($song['artist']) }}" href="{{ URL::to('search/'.htmlspecialchars($song['artist'])) }}">{{ htmlspecialchars($song['artist']) }}</a>
            		<div class="clearfix"></div>
            	</div>
           	</div>
        </div>
    @endforeach
    <div class="clearfix"></div>
@stop