@extends('admin.index')

@section('meta-content')
<title>{{ Lang::get('words.admin_alt').' - '.Lang::get('words.users') }}</title>
@stop

@section('content')
<?php
    $pl_counts = DB::table('playlists')->whereIn('user_id', $users->lists('id'))->select(DB::raw('user_id, count(id) as count'))->groupBy('user_id')->get();
    $pl_array = array();
    foreach($pl_counts as $pl_count) {
        $pl_array[$pl_count->user_id] = $pl_count->count;
    }
?>
<div class="row">
	<div class="col-xs-12">
		<ol class="breadcrumb">
			<li><a href="{{ URL::to('admin') }}"><i class="fa fa-dashboard"></i> {{ Lang::get('words.admin') }}</a></li>
            <li class="active">{{ Lang::get('words.users') }} (<b>{{ DB::table("users")->count() }}</b>)</li>
		</ol>
	</div>
</div>
<div class="row">
    <form method="get">
        <div class="col-xs-12">
            <div class="form-group input-group">
                <input type="text" class="form-control" name="q" value="@if(Input::get('q')){{ Input::get('q') }}@endif" placeholder="{{ Lang::get('words.search') }}" aria-describedby="basic-addon2">
                <div class="input-group-btn">
                    <button type="submit" class="btn btn-primary"><span class="fa fa-search"></span> {{ Lang::get('words.search') }}</button>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </form>
</div>
<div class="row">
	<div class="col-xs-12">
        <div class="table-responsive">
            <table class="table">
                <tr>
                   <th>{{ Lang::get('words.username') }}</th>
                   <th>{{ Lang::get('words.email') }}</th>
                   <th>{{ Lang::get('words.playlists') }}</th>
                   <th>{{ Lang::get('words.created') }}</th>
                   <th>{{ Lang::get('words.active') }}</th>
                   <th>{{ Lang::get('words.actions') }}</th>
                </tr>
                @foreach($users as $user)
                    <?php 
                        $playlists_count = isset($pl_array[$user->id]) ? $pl_array[$user->id] : 0;
                    ?>
                    <tr>
                        <td>{{ $user->username }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $playlists_count }}</td>
                        <td>{{ $user->created_at->toFormattedDateString() }}</td>
                        <td>
                            @if($user->active)
                                <label class="label label-success">{{ Lang::get('words.yes') }}</label>
                            @else
                                <label class="label label-warning">{{ Lang::get('words.no') }}</label>
                            @endif
                        </td>
                        <td>
                            @if($user->admin) 
                                <a data-target="#user-mode-modal" data-toggle="modal" data-user="{{ $user->id }}" title="{{ Lang::get('words.make') }} {{ Lang::get('words.user') }}" class="btn btn-xs btn-success"><span class="fa fa-user-secret"></span> {{ Lang::get('words.admin') }}</a>
                            @else
                                <a data-target="#user-mode-modal" data-toggle="modal" data-user="{{ $user->id }}" title="{{ Lang::get('words.make') }} {{ Lang::get('words.admin') }}" class="btn btn-xs btn-warning"><span class="fa fa-user"></span> {{ Lang::get('words.user') }}</a>
                            @endif
                            
                            <a data-target="#edit-user-modal" data-toggle="modal" data-user="{{ $user->id }}" data-username="{{ $user->username }}" data-email="{{ $user->email }}" title="{{ Lang::get('words.edit-user') }}" class="btn btn-xs btn-danger"><span class="fa fa-edit"></span> {{ Lang::get('words.edit') }}</a>
                            
                            @if($user->banned) 
                                <a data-target="#user-status-modal" data-toggle="modal" data-user="{{ $user->id }}" title="Unban User" class="btn btn-xs btn-danger"><span class="fa fa-ban"></span> {{ Lang::get('words.unban') }}</a>
                            @else
                                <a data-target="#user-status-modal" data-toggle="modal" data-user="{{ $user->id }}" title="Ban User" class="btn btn-xs btn-success"><span class="fa fa-check"></span> {{ Lang::get('words.ban') }}</a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-xs-12 text-center">
        {{ $users->links() }}
    </div>
</div>

<div class="modal fade" id="edit-user-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">{{ Lang::get('words.edit-user') }}</h4>
            </div>
            <form id="edit-user-form" role="form" method="post" action="{{ URL::to('user/admin/user/edit') }}">
                <div class="modal-body">
                    <input type="hidden" name="user" value="">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <div class="form-group">
                        <label>{{ Lang::get('words.username') }}:</label>
                        <input type="text" class="form-control" name="username" placeholder="{{ Lang::get('words.username') }}">
                    </div>
                    <div class="form-group">
                        <label>{{ Lang::get('words.email') }}:</label>
                        <input type="text" class="form-control" name="email" placeholder="{{ Lang::get('words.email') }}">
                    </div>
                    <div class="form-group">
                        <label>{{ Lang::get('words.new-password') }}:</label>
                        <input type="password" name="password" autocomplete="off" class="form-control" placeholder="{{ Lang::get('words.new-password') }}">
                    </div>
                    <div class="form-group">
                        <label>{{ Lang::get('words.confirm-password') }}:</label>
                        <input type="password" name="password_confirmation" autocomplete="off" class="form-control" placeholder="{{ Lang::get('words.confirm-password') }}">
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.save-user') }}">
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="user-mode-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">{{ Lang::get('words.change-user-mode') }}</h4>
            </div>
            <form id="user-mode-form" role="form" method="post" action="{{ URL::to('user/admin/user/mode') }}">
                <div class="modal-body">
                    <input type="hidden" name="user" value="">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <h5>{{ Lang::get('words.change-user-mode-msg') }}</h5>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.change-mode') }}">
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="user-status-modal" tabindex="-1" role="dialog" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">{{ Lang::get('words.change-user-status') }}</h4>
            </div>
            <form id="user-status-form" role="form" method="post" action="{{ URL::to('user/admin/user/status') }}">
                <div class="modal-body">
                    <input type="hidden" name="user" value="">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <h5>{{ Lang::get('words.change-user-status-msg') }}</h5>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-danger btn-block" value="{{ Lang::get('words.change-status') }}">
                </div>
            </form>
        </div>
    </div>
</div>
@stop