<!doctype html>
<html lang="en">
<head>
	@yield('meta-content')
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
	<meta name="rootURL" content="{{ URL::to('/') }}">
	<meta name="_token" content="{{ csrf_token() }}">
	<meta name="youtube_key" content="{{ $settings->youtube_key }}">
	
	<link rel="stylesheet" href="{{ URL::asset('assets/css/bootstrap.css') }}" />
	<link rel="stylesheet" href="{{ URL::asset('assets/css/font-awesome.css') }}" />
	<link rel="stylesheet" href="{{ URL::asset('assets/css/jquery.bxslider.css') }}" />
	<link rel="stylesheet" type="text/css" href="{{ URL::to('assets/css/bootstrap-datepicker3.css') }}">
	<link rel="stylesheet" type="text/css" href="{{ URL::to('assets/css/bootstrap-colorpicker.css') }}">
	<link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/style.css') }}">

    <link rel="icon" href="{{ URL::asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <link rel="shortcut icon" href="{{ URL::asset('assets/images/favicon.ico') }}" type="image/x-icon">

    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery-1.11.0.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery-ui.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/bootstrap.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jscroll.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.form.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.pjax.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/bootstrap-tagsinput.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/typeahead.bundle.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/nprogress.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.bxslider.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/js/jquery.noty.js') }}"></script>
	<script type="text/javascript" src="{{ URL::to('assets/js/bootstrap-datepicker.js') }}"></script>
	<script type="text/javascript" src="{{ URL::asset('assets/js/bootstrap-colorpicker.js') }}"></script>
    @yield('resources')
    <script type="text/javascript" src="{{ URL::asset('assets/js/app.js?v=2') }}"></script>
    <script type="text/javascript">
      $(document).ready(function(){
        rootURL = "{{ URL::to('/') }}";
      });
    </script>
</head>
<body>
<div id="wrapper" class="hidden">
	<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
		<div class="container" style="max-width:980px">
			<div class="navbar-header">
				<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
			        <span class="sr-only">Toggle navigation</span>
			        <span class="icon-bar"></span>
			        <span class="icon-bar"></span>
			        <span class="icon-bar"></span>
			    </button>
				<a class="navbar-brand pjax" title="{{ Lang::get('words.admin_alt') }}" href="{{ URL::to('admin') }}">{{ Lang::get('words.admin_alt') }}</a>
			</div>
			<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
      			<ul class="nav navbar-nav">
      				<li @if(Request::is('user/admin/home') || Request::is('user/admin')) class="active" @endif>
			            <a class="pjax" href="{{ URL::to('user/admin/home') }}"><i class="fa fa-home"></i> {{ Lang::get('words.home') }}</a>
			        </li>
			        <li @if(Request::is('user/admin/user')) class="active" @endif>
			            <a class="pjax" href="{{ URL::to('user/admin/user') }}"><i class="fa fa-user"></i> {{ Lang::get('words.users') }}</a>
			        </li>
			        <li @if(Request::is('user/admin/settings')) class="active" @endif>
			            <a class="pjax" href="{{ URL::to('user/admin/settings') }}"><i class="fa fa-gear"></i> {{ Lang::get('words.settings') }}</a>
			        </li>
			        <li @if(Request::is('user/admin/pages')) class="active" @endif>
			            <a class="pjax" href="{{ URL::to('user/admin/pages') }}"><i class="fa fa-file-text"></i> {{ Lang::get('words.pages') }}</a>
			        </li>
      			</ul>
      		</div>
		</div>
	</nav>

	<div id="page-wrapper" style="margin-top:60px;">
		<div class="container" style="max-width:980px">
			<div class="col-xs-12">
			<link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/jquery-ui.css') }}">
			<style type="text/css">
    ul.pagination {
    	opacity: 1;
    }
    #wrapper {
		    padding: 0;
		}
    	#sortable { list-style-type: none; margin: 0; padding: 0; width: 100%; }
		#sortable li { margin: 0 3px 3px 3px; padding: 2px 0 2px 20px; font-size: 1.2em; height: 30px; }
		#sortable li span { cursor: pointer; float: right; padding: 3px 10px; }
		.btn-file {
		  overflow: hidden;
		    position: relative;
		}
		.btn-file input[type="file"] {
		    background: white;
		    cursor: inherit;
		    display: block;
		    font-size: 999px;
		    min-height: 100%;
		    min-width: 100%;
		    opacity: 0;
		    outline: medium none;
		    position: absolute;
		    right: 0;
		    text-align: right;
		    top: 0;
		}
		.navbar-header {
		    width: auto;
		}
    </style>
				@yield('content')
			</div>
		</div>
	</div>
</div>
<br />
<br />
<script type="text/javascript">
 	@if(Session::get('message') != '' && Session::get('status') != '')
        var n = noty({
                text        : '{{ Session::get("message") }}',
                type        : '{{ Session::get("status") }}',
                dismissQueue: true,
                layout      : 'bottomRight',
                closeWith   : ['click'],
                theme       : 'relax',
                maxVisible  : 10
            });
        <?php Session::forget('status'); Session::forget('message'); ?>
    @endif
</script>
</body>
</html>