@extends('admin.index')
@section('meta-content')
<title>{{ Lang::get('words.admin_alt').' - '.Lang::get('words.home') }}</title>
@stop
@section('content')
	<div class="row">
		<div class="col-xs-12">
			<ol class="breadcrumb">
				<li><a href="{{ URL::to('admin') }}">{{ Lang::get('words.admin') }}</a></li>
				<li class="active">{{ Lang::get('words.home') }}</li>
			</ol>
		</div>
	</div>
	<div class="row">
		<div class="col-xs-12">
			<form method="post" action="{{ URL::to('user/admin/home') }}" accept-charset="UTF-8">
		        <div class="form-group">
		            <label for="max-top" class="col-sm-3 control-label padding0">{{ Lang::get('words.genres_country') }}: </label>
		            <div class="col-sm-9 padding0">
		                <select name="country_code" class="form-control">
		                    <option @if($settings->country_code == "al") selected="selected" @endif value="al">Albania</option>
		                    <option @if($settings->country_code == "cz") selected="selected" @endif value="cz">Czech Republic</option>
		                    <option @if($settings->country_code == "ua") selected="selected" @endif value="ua">Ukraine</option>
		                    <option @if($settings->country_code == "dz") selected="selected" @endif value="dz">Algeria</option>
		                    <option @if($settings->country_code == "ao") selected="selected" @endif value="ao">Angola</option>
		                    <option @if($settings->country_code == "ai") selected="selected" @endif value="ai">Anguilla</option>
		                    <option @if($settings->country_code == "ag") selected="selected" @endif value="ag">Antigua and Barbuda</option>
		                    <option @if($settings->country_code == "ar") selected="selected" @endif value="ar">Argentina</option>
		                    <option @if($settings->country_code == "am") selected="selected" @endif value="am">Armenia</option>
		                    <option @if($settings->country_code == "au") selected="selected" @endif value="au">Australia</option>
		                    <option @if($settings->country_code == "az") selected="selected" @endif value="az">Azerbaijan</option>
		                    <option @if($settings->country_code == "bs") selected="selected" @endif value="bs">Bahamas</option>
		                    <option @if($settings->country_code == "bh") selected="selected" @endif value="bh">Bahrain</option>
		                    <option @if($settings->country_code == "bb") selected="selected" @endif value="bb">Barbados</option>
		                    <option @if($settings->country_code == "by") selected="selected" @endif value="by">Belarus</option>
		                    <option @if($settings->country_code == "be") selected="selected" @endif value="be">Belgium</option>
		                    <option @if($settings->country_code == "bz") selected="selected" @endif value="bz">Belize</option>
		                    <option @if($settings->country_code == "bj") selected="selected" @endif value="bj">Benin</option>
		                    <option @if($settings->country_code == "bm") selected="selected" @endif value="bm">Bermuda</option>
		                    <option @if($settings->country_code == "bt") selected="selected" @endif value="bt">Bhutan</option>
		                    <option @if($settings->country_code == "bo") selected="selected" @endif value="bo">Bolivia, Plurinational State of</option>
		                    <option @if($settings->country_code == "bw") selected="selected" @endif value="bw">Botswana</option>
		                    <option @if($settings->country_code == "br") selected="selected" @endif value="br">Brazil</option>
		                    <option @if($settings->country_code == "bn") selected="selected" @endif value="bn">Brunei Darussalam</option>
		                    <option @if($settings->country_code == "bf") selected="selected" @endif value="bf">Burkina Faso</option>
		                    <option @if($settings->country_code == "kh") selected="selected" @endif value="kh">Cambodia</option>
		                    <option @if($settings->country_code == "ca") selected="selected" @endif value="ca">Canada</option>
		                    <option @if($settings->country_code == "cv") selected="selected" @endif value="cv">Cape Verde</option>
		                    <option @if($settings->country_code == "ky") selected="selected" @endif value="ky">Cayman Islands</option>
		                    <option @if($settings->country_code == "td") selected="selected" @endif value="td">Chad</option>
		                    <option @if($settings->country_code == "cl") selected="selected" @endif value="cl">Chile</option>
		                    <option @if($settings->country_code == "co") selected="selected" @endif value="co">Colombia</option>
		                    <option @if($settings->country_code == "cg") selected="selected" @endif value="cg">Congo</option>
		                    <option @if($settings->country_code == "cr") selected="selected" @endif value="cr">Costa Rica</option>
		                    <option @if($settings->country_code == "cy") selected="selected" @endif value="cy">Cyprus</option>
		                    <option @if($settings->country_code == "dk") selected="selected" @endif value="dk">Denmark</option>
		                    <option @if($settings->country_code == "de") selected="selected" @endif value="de">Germany</option>
		                    <option @if($settings->country_code == "dm") selected="selected" @endif value="dm">Dominica</option>
		                    <option @if($settings->country_code == "ec") selected="selected" @endif value="ec">Ecuador</option>
		                    <option @if($settings->country_code == "ee") selected="selected" @endif value="ee">Estonia</option>
		                    <option @if($settings->country_code == "eg") selected="selected" @endif value="eg">Egypt</option>
		                    <option @if($settings->country_code == "sv") selected="selected" @endif value="sv">El Salvador</option>
		                    <option @if($settings->country_code == "es") selected="selected" @endif value="es">Spain</option>
		                    <option @if($settings->country_code == "fj") selected="selected" @endif value="fj">Fiji</option>
		                    <option @if($settings->country_code == "fr") selected="selected" @endif value="fr">France</option>
		                    <option @if($settings->country_code == "gm") selected="selected" @endif value="gm">Gambia</option>
		                    <option @if($settings->country_code == "gh") selected="selected" @endif value="gh">Ghana</option>
		                    <option @if($settings->country_code == "gr") selected="selected" @endif value="gr">Greece</option>
		                    <option @if($settings->country_code == "gd") selected="selected" @endif value="gd">Grenada</option>
		                    <option @if($settings->country_code == "gt") selected="selected" @endif value="gt">Guatemala</option>
		                    <option @if($settings->country_code == "gw") selected="selected" @endif value="gw">Guinea-Bissau</option>
		                    <option @if($settings->country_code == "gy") selected="selected" @endif value="gy">Guyana</option>
		                    <option @if($settings->country_code == "hn") selected="selected" @endif value="hn">Honduras</option>
		                    <option @if($settings->country_code == "hk") selected="selected" @endif value="hk">Hong Kong</option>
		                    <option @if($settings->country_code == "hr") selected="selected" @endif value="hr">Croatia</option>
		                    <option @if($settings->country_code == "is") selected="selected" @endif value="is">Iceland</option>
		                    <option @if($settings->country_code == "in") selected="selected" @endif value="in">India</option>
		                    <option @if($settings->country_code == "id") selected="selected" @endif value="id">Indonesia</option>
		                    <option @if($settings->country_code == "ie") selected="selected" @endif value="ie">Ireland</option>
		                    <option @if($settings->country_code == "il") selected="selected" @endif value="il">Israel</option>
		                    <option @if($settings->country_code == "it") selected="selected" @endif value="it">Italy</option>
		                    <option @if($settings->country_code == "jm") selected="selected" @endif value="jm">Jamaica</option>
		                    <option @if($settings->country_code == "jo") selected="selected" @endif value="jo">Jordan</option>
		                    <option @if($settings->country_code == "kz") selected="selected" @endif value="kz">Kazakhstan</option>
		                    <option @if($settings->country_code == "ke") selected="selected" @endif value="ke">Kenya</option>
		                    <option @if($settings->country_code == "kw") selected="selected" @endif value="kw">Kuwait</option>
		                    <option @if($settings->country_code == "kg") selected="selected" @endif value="kg">Kyrgyzstan</option>
		                    <option @if($settings->country_code == "la") selected="selected" @endif value="la">Lao People's Democratic Republic</option>
		                    <option @if($settings->country_code == "lv") selected="selected" @endif value="lv">Latvia</option>
		                    <option @if($settings->country_code == "lb") selected="selected" @endif value="lb">Lebanon</option>
		                    <option @if($settings->country_code == "lr") selected="selected" @endif value="lr">Liberia</option>
		                    <option @if($settings->country_code == "li") selected="selected" @endif value="li">Liechtenstein</option>
		                    <option @if($settings->country_code == "lt") selected="selected" @endif value="lt">Lithuania</option>
		                    <option @if($settings->country_code == "lu") selected="selected" @endif value="lu">Luxembourg</option>
		                    <option @if($settings->country_code == "mo") selected="selected" @endif value="mo">Macao</option>
		                    <option @if($settings->country_code == "mk") selected="selected" @endif value="mk">Macedonia, the former Yugoslav Republic of</option>
		                    <option @if($settings->country_code == "mg") selected="selected" @endif value="mg">Madagascar</option>
		                    <option @if($settings->country_code == "hu") selected="selected" @endif value="hu">Hungary</option>
		                    <option @if($settings->country_code == "mw") selected="selected" @endif value="mw">Malawi</option>
		                    <option @if($settings->country_code == "my") selected="selected" @endif value="my">Malaysia</option>
		                    <option @if($settings->country_code == "ml") selected="selected" @endif value="ml">Mali</option>
		                    <option @if($settings->country_code == "mt") selected="selected" @endif value="mt">Malta</option>
		                    <option @if($settings->country_code == "mr") selected="selected" @endif value="mr">Mauritania</option>
		                    <option @if($settings->country_code == "mu") selected="selected" @endif value="mu">Mauritius</option>
		                    <option @if($settings->country_code == "mx") selected="selected" @endif value="mx">Mexico</option>
		                    <option @if($settings->country_code == "fm") selected="selected" @endif value="fm">Micronesia, Federated States of</option>
		                    <option @if($settings->country_code == "md") selected="selected" @endif value="md">Moldova, Republic of</option>
		                    <option @if($settings->country_code == "mn") selected="selected" @endif value="mn">Mongolia</option>
		                    <option @if($settings->country_code == "me") selected="selected" @endif value="me">Montenegro</option>
		                    <option @if($settings->country_code == "ms") selected="selected" @endif value="ms">Montserrat</option>
		                    <option @if($settings->country_code == "mz") selected="selected" @endif value="mz">Mozambique</option>
		                    <option @if($settings->country_code == "na") selected="selected" @endif value="na">Namibia</option>
		                    <option @if($settings->country_code == "nl") selected="selected" @endif value="nl">Netherlands</option>
		                    <option @if($settings->country_code == "np") selected="selected" @endif value="np">Nepal</option>
		                    <option @if($settings->country_code == "nz") selected="selected" @endif value="nz">New Zealand</option>
		                    <option @if($settings->country_code == "ni") selected="selected" @endif value="ni">Nicaragua</option>
		                    <option @if($settings->country_code == "ne") selected="selected" @endif value="ne">Niger</option>
		                    <option @if($settings->country_code == "ng") selected="selected" @endif value="ng">Nigeria</option>
		                    <option @if($settings->country_code == "no") selected="selected" @endif value="no">Norway</option>
		                    <option @if($settings->country_code == "om") selected="selected" @endif value="om">Oman</option>
		                    <option @if($settings->country_code == "at") selected="selected" @endif value="at">Austria</option>
		                    <option @if($settings->country_code == "pk") selected="selected" @endif value="pk">Pakistan</option>
		                    <option @if($settings->country_code == "pw") selected="selected" @endif value="pw">Palau</option>
		                    <option @if($settings->country_code == "pa") selected="selected" @endif value="pa">Panama</option>
		                    <option @if($settings->country_code == "pg") selected="selected" @endif value="pg">Papua New Guinea</option>
		                    <option @if($settings->country_code == "py") selected="selected" @endif value="py">Paraguay</option>
		                    <option @if($settings->country_code == "pe") selected="selected" @endif value="pe">Peru</option>
		                    <option @if($settings->country_code == "ph") selected="selected" @endif value="ph">Philippines</option>
		                    <option @if($settings->country_code == "pl") selected="selected" @endif value="pl">Poland</option>
		                    <option @if($settings->country_code == "pt") selected="selected" @endif value="pt">Portugal</option>
		                    <option @if($settings->country_code == "do") selected="selected" @endif value="do">Dominican Republic</option>
		                    <option @if($settings->country_code == "ro") selected="selected" @endif value="ro">Romania</option>
		                    <option @if($settings->country_code == "kn") selected="selected" @endif value="kn">Saint Kitts and Nevis</option>
		                    <option @if($settings->country_code == "lc") selected="selected" @endif value="lc">Saint Lucia</option>
		                    <option @if($settings->country_code == "vc") selected="selected" @endif value="vc">Saint Vincent and the Grenadines</option>
		                    <option @if($settings->country_code == "sa") selected="selected" @endif value="sa">Saudi Arabia</option>
		                    <option @if($settings->country_code == "st") selected="selected" @endif value="st">Sao Tome and Principe</option>
		                    <option @if($settings->country_code == "ch") selected="selected" @endif value="ch">Switzerland</option>
		                    <option @if($settings->country_code == "sn") selected="selected" @endif value="sn">Senegal</option>
		                    <option @if($settings->country_code == "sc") selected="selected" @endif value="sc">Seychelles</option>
		                    <option @if($settings->country_code == "sl") selected="selected" @endif value="sl">Sierra Leone</option>
		                    <option @if($settings->country_code == "sg") selected="selected" @endif value="sg">Singapore</option>
		                    <option @if($settings->country_code == "sk") selected="selected" @endif value="sk">Slovakia</option>
		                    <option @if($settings->country_code == "si") selected="selected" @endif value="si">Slovenia</option>
		                    <option @if($settings->country_code == "sb") selected="selected" @endif value="sb">Solomon Islands</option>
		                    <option @if($settings->country_code == "za") selected="selected" @endif value="za">South Africa</option>
		                    <option @if($settings->country_code == "lk") selected="selected" @endif value="lk">Sri Lanka</option>
		                    <option @if($settings->country_code == "fi") selected="selected" @endif value="fi">Finland</option>
		                    <option @if($settings->country_code == "sr") selected="selected" @endif value="sr">Suriname</option>
		                    <option @if($settings->country_code == "se") selected="selected" @endif value="se">Sweden</option>
		                    <option @if($settings->country_code == "sz") selected="selected" @endif value="sz">Swaziland</option>
		                    <option @if($settings->country_code == "tj") selected="selected" @endif value="tj">Tajikistan</option>
		                    <option @if($settings->country_code == "tz") selected="selected" @endif value="tz">Tanzania, United Republic of</option>
		                    <option @if($settings->country_code == "th") selected="selected" @endif value="th">Thailand</option>
		                    <option @if($settings->country_code == "tt") selected="selected" @endif value="tt">Trinidad and Tobago</option>
		                    <option @if($settings->country_code == "tn") selected="selected" @endif value="tn">Tunisia</option>
		                    <option @if($settings->country_code == "tm") selected="selected" @endif value="tm">Turkmenistan</option>
		                    <option @if($settings->country_code == "tc") selected="selected" @endif value="tc">Turks and Caicos Islands</option>
		                    <option @if($settings->country_code == "tr") selected="selected" @endif value="tr">Turkey</option>
		                    <option @if($settings->country_code == "gb") selected="selected" @endif value="gb">United Kingdom</option>
		                    <option @if($settings->country_code == "us") selected="selected" @endif value="us">United States</option>
		                    <option @if($settings->country_code == "ug") selected="selected" @endif value="ug">Uganda</option>
		                    <option @if($settings->country_code == "qa") selected="selected" @endif value="qa">Qatar</option>
		                    <option @if($settings->country_code == "ae") selected="selected" @endif value="ae">United Arab Emirates</option>
		                    <option @if($settings->country_code == "uy") selected="selected" @endif value="uy">Uruguay</option>
		                    <option @if($settings->country_code == "uz") selected="selected" @endif value="uz">Uzbekistan</option>
		                    <option @if($settings->country_code == "ve") selected="selected" @endif value="ve">Venezuela, Bolivarian Republic of</option>
		                    <option @if($settings->country_code == "vn") selected="selected" @endif value="vn">Viet Nam</option>
		                    <option @if($settings->country_code == "vg") selected="selected" @endif value="vg">Virgin Islands, British</option>
		                    <option @if($settings->country_code == "ye") selected="selected" @endif value="ye">Yemen</option>
		                    <option @if($settings->country_code == "zw") selected="selected" @endif value="zw">Zimbabwe</option>
		                    <option @if($settings->country_code == "bg") selected="selected" @endif value="bg">Bulgaria</option>
		                    <option @if($settings->country_code == "ru") selected="selected" @endif value="ru">Russian Federation</option>
		                    <option @if($settings->country_code == "kr") selected="selected" @endif value="kr">Korea, Republic of</option>
		                    <option @if($settings->country_code == "cn") selected="selected" @endif value="cn">China</option>
		                    <option @if($settings->country_code == "tw") selected="selected" @endif value="tw">Taiwan, Province of China</option>
		                    <option @if($settings->country_code == "jp") selected="selected" @endif value="jp">Japan</option>

		                </select>
		            </div>
		            <div class="clearfix"></div>
		        </div>
		        <div class="well well-sm text-center text-muted">{{ Lang::get('words.sort_title') }}</div>
		        <ul id="sortable">
		            @foreach($genres as $genre)
		                <li id="{{ $genre->id }}" class="ui-state-default">{{ Lang::get('words.'.$genre->name) }} <span title="Enable/Disable genre" class="toggleGenre fa @if($genre->is_visible) fa-eye @else fa-eye-slash @endif"></span></li>
		            @endforeach
		        </ul>
		        @foreach($genres as $genre)
		            <input type="hidden" name="{{ $genre->id }}" value="{{ $genre->order_id }}">
		        @endforeach

		        <input type="hidden" name="_token" value="{{ csrf_token() }}">
		        <br>
		        <button type="submit" class="btn btn-success btn-block"><i class="fa fa-home"></i> {{ Lang::get('words.update-settings') }}</button>
		    </form>
		</div>
	</div>
@stop

