<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

Route::when('*', 'csrf', array('post'));

Route::get('/{category?}', 'HomeController@index');
Route::post('install', 'HomeController@install');


//Route::get('/', function(){
    //Artisan::call('db:seed', array('--quiet' => true, '--force' => true, '--class' => 'PagesTableSeeder'));
//});

Route::get('search/{title}', 'SearchController@index');
Route::get('track/{title}/{id}', 'SearchController@getTrack');

Route::group(
    array('before' => 'auth'),
    function () {
        Route::get('user/playlist', 'PlaylistController@index');
        Route::post('user/playlist', 'PlaylistController@create');
        Route::post('user/playlist/track/add', 'PlaylistController@addTrack');
        Route::post('user/playlist/album/add', 'PlaylistController@addAlbum');
        Route::get('user/playlist/{id}', 'PlaylistController@show');
        Route::post('user/playlist/{id}/play', 'PlaylistController@playlistPlay');
        Route::post('user/playlist/{id}/edit', 'PlaylistController@edit');
        Route::post('user/playlist/{id}/track/remove', 'PlaylistController@removeTrack');
        Route::post('user/playlist/{id}/delete', 'PlaylistController@delete');
        Route::get('user/settings', 'UserController@settings');
        Route::post('user/settings', 'UserController@update');
    }
);

Route::group(
    array('before' => 'admin'),
    function () {
        Route::get('user/admin', 'AdminController@index');

        Route::get('user/admin/home', 'AdminController@index');
        Route::post('user/admin/home', 'AdminController@updateHome');

        Route::get('user/admin/settings', 'AdminController@getSettings');
        Route::post('user/admin/settings', 'AdminController@updateSettings');

        Route::get('user/admin/user', 'AdminController@getUsers');
        Route::post('user/admin/user/edit', 'UserController@update');
        Route::post('user/admin/user/mode', 'AdminController@toggleMode');
        Route::post('user/admin/user/status', 'AdminController@toggleStatus');

        Route::get('user/admin/pages', 'AdminController@getPages');
        Route::post('user/admin/pages', 'AdminController@updatePages');

        Route::post('user/admin/genres', 'AdminController@toggleGenre');


    }
);

Route::get('ads/{type}', function($type){
    $settings = Setting::first();
    return View::make('ads.index', array('settings' => $settings, 'type' => $type));
});

Route::get('download/track/{trackid}', function($trackid){
    if($trackid) {
        $settings = Setting::first();
        $data = file_get_contents('https://api.soundcloud.com/tracks/'.trim($trackid).'?client_id='.$settings->soundcloud_key);
        $data = json_decode($data, true);
        if(isset($data['id'])) {
            $trackLink = 'https://api.soundcloud.com/tracks/'.$data['id'].'/stream?client_id='.$settings->soundcloud_key;

            $headers = get_headers($trackLink, 1);
            $filename = str_replace('-', ' ', $data['title'])." - [".$settings->website_name."]".".mp3";
            $mime_type = "audio/mpeg, audio/x-mpeg, audio/x-mpeg-3, audio/mpeg3";

            header('Content-Description: File Transfer');
            header("Content-Type: audio/mpeg");
            header('Content-Disposition: attachment; filename="'.basename($filename).'"'); // adding quotes and stripping full path
            header('Content-Transfer-Encoding: binary');
            header('Connection: Keep-Alive');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header("Cache-Control: private", false);
            header('Pragma: public');

            if (isset($headers['Location']) && isset($headers['Content-Length'][1])) {
                header('Content-length: ' . $headers["Content-Length"][1]);
                readfile($headers['Location']);
            } elseif(parse_url($trackID, PHP_URL_HOST) == parse_url(URL::to('/'), PHP_URL_HOST )) {
                header('Content-length: ' . $headers["Content-Length"]);
                readfile($trackLink);
            } else {
                return Redirect::to('/')->with(array('toastMsg' =>Lang::get('words.invalid_track'), 'toastType' => 'showErrorToast'));
            }
        }
    }

});

Route::get(
    'language/{langcode}',
    function ($langcode) {
        if (is_dir(dirname(__File__).'/lang/'.$langcode)) {
            Session::put('language', $langcode);
            App::setLocale($langcode);
            return Redirect::to('/');
        }
    }
);

// User Controller Routes
Route::post('login', 'UserController@login');
Route::post('signup', 'UserController@signup');

Route::post('password/remind', 'RemindersController@postRemind');
// ********* Activation **** //
Route::get('user/activation', 'UserController@activation');

Route::get('password/reset/{token}', 'RemindersController@getReset');
Route::post('password/reset/{token}', 'RemindersController@postReset');

// ********* PAGES ******** //
Route::get('page/{title}', 'PageController@show');


Route::get(
    'user/logout',
    function () {
        Auth::logout();
        return Redirect::to('/');
    }
);
Route::get('auth/vk', 'UserController@loginWithVkontakte');
Route::get('auth/facebook', 'UserController@loginWithFacebook');
Route::get('auth/twitter', 'UserController@loginWithTwitter');
Route::get('auth/google', 'UserController@loginWithGoogle');

Route::get('update', 'HomeController@update');

Event::listen('illuminate.query', function($sql)
{
    //var_dump($sql);
}); 