<?php

use Illuminate\Database\Migrations\Migration;

class CreateGenresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(
            'genres',
            function ($table) {
                $table->increments('id');
                $table->string('name', 50);
                $table->integer('genre_id');
                $table->integer('order_id');
                $table->boolean('is_visible')->default(1);
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('genres');
    }
}
