<?php

class LanguageController extends BaseController
{
    /*
    |--------------------------------------------------------------------------
    | Default Language Controller
    |--------------------------------------------------------------------------
    |
    | You may wish to use controllers instead of, or in addition to, Closure
    | based routes. That's great! Here is an example controller method to
    | get you started. To route to this controller, just add the route:
    |
    |	Route::get('/', 'LanguageController@showWelcome');
    |
    */

    // ********** Show all available Languages ********** //

    public function all()
    {
        $langArray = array(); // Available Languages.
        $langDir = dirname(__FILE__).'/../lang/';

        $isoLangFile = $langDir.'IsoLangs.json';
        if (file_exists($isoLangFile)) {
            $handle = fopen($isoLangFile, 'r');
            $json = fread($handle, filesize($isoLangFile));
            $jsonObj = json_decode($json, true); // All Languages Object.
        }

        if (is_dir($langDir)) {
            $dirhandle = array_diff(scandir($langDir), array('..', '.'));
            foreach ($dirhandle as $dir) {
                if (is_dir($langDir.$dir)) {
                    $langArray[$dir] = $jsonObj[$dir]['nativeName'];
                }
            }
        }

        return $langArray;
    }
}
