<?php

class HomeController extends BaseController {

    /*
    |--------------------------------------------------------------------------
    | Default Home Controller
    |--------------------------------------------------------------------------
    |
    | You may wish to use controllers instead of, or in addition to, Closure
    | based routes. That's great! Here is an example controller method to
    | get you started. To route to this controller, just add the route:
    |
    |	Route::get('/', 'HomeController@showWelcome');
    |
    */

    public function index($category=null)
    {
    	try {
            $settings = Setting::first();
            if (!$settings) {
                throw new Exception("Install Script");
            }
            $searchKey = htmlspecialchars(Input::get('q'));
            if (!empty($searchKey)) {
                $searchKey = trim($searchKey);
                return Redirect::to('search/'.$searchKey);
            } else {
                return App::make('AppleAPIController')->getSongs($category);
                //return View::make('home.index', array('albums' => $albums, 'topAlbums' => $topAlbums, 'trendingAlbums' => $trendingAlbums, 'popularAlbums' => $popularAlbums, 'artists' => $artists));
            }                            
        }
        catch (Exception $ex) {
            return View::make('install');
        }
	}

	public function install() {
		$inputs = Input::all();
		$validator = Validator::make($inputs, array(
			'username' => 'required|alpha_dash|between:3,15',
			'password' => 'required|alpha_dash|between:3,15',
			'email' => 'required|email',
            'inputDBhost' => 'required',
            'inputDBname' => 'required',
            'inputDBusername' => 'required',
            )
        );

        if($validator->passes()) {
        	//dd('ok');
        	$con = @mysqli_connect($inputs['inputDBhost'], $inputs['inputDBusername'], $inputs['inputDBpassword'], $inputs['inputDBname']);
        	if(!mysqli_connect_errno($con)) {
        		$file = '../app/config/config.php';
                $configs = "<?php
                                return array(
                                        'DBhost' => '{$inputs['inputDBhost']}',
                                        'DBname' => '{$inputs['inputDBname']}',
                                        'DBuser' => '{$inputs['inputDBusername']}',
                                        'DBpassword' => '{$inputs['inputDBpassword']}'
                                    );";
                $write_config_file = file_put_contents($file, $configs);
                if ($write_config_file !== false) {
                	// Temporarily attempt to connect to database
                    Config::set('database.connections.mysql.host', $inputs['inputDBhost']);
                    Config::set('database.connections.mysql.database', $inputs['inputDBname']);
                    Config::set('database.connections.mysql.username', $inputs['inputDBusername']);
                    Config::set('database.connections.mysql.password', $inputs['inputDBpassword']);

                    //Migrate the database tables
                    Artisan::call('migrate', ['--quiet' => true, '--force' => true]);
                    
                    //Seed database tables with default settings.
                    Artisan::call('db:seed', array('--quiet' => true, '--force' => true, '--class' => 'SettingsTableSeeder'));
                    Artisan::call('db:seed', array('--quiet' => true, '--force' => true, '--class' => 'PagesTableSeeder'));
                    Artisan::call('db:seed', array('--quiet' => true, '--force' => true, '--class' => 'GenresTableSeeder'));

                    $user = new User();
			        $user->username = $inputs['username'];
			        $user->email = $inputs['email'];
			        $user->password = Hash::make($inputs['password']);
			        $user->active = 1;
			        $user->admin = 1;
			        $user->save();

                    Auth::login($user, true);
                    return Redirect::to('/');

                }
                else {
                	return Redirect::to('/')->with(array('message' => 'couldn\'t write file'));
                }
        	}
        	else {
        		return Redirect::to('/')->with(array('message' => 'MySQL connection error'));
        	}
        }
        else {
        	return Redirect::to('/')->with(array('message' => 'Validation failed'.$validator->messages()->all()[0]));
        }
	}

    public function update() {
        $this->updateV1_2();
        return Redirect::to('/')->with(array('message' => 'Script updated Successfully!', 'status' => 'success'));
    }

    private function updateV1_2() {
        if(Schema::hasTable('settings')) {
            Schema::table('settings', function($table)
            {
                if (!Schema::hasColumn('settings', 'youtube_key'))
                {
                    $table->string('youtube_key');
                }
            });
        }
        return true;
    }

}
