<?php
$heading_text = noo_get_option( 'noo_resume_heading_text', '' );
$show_search_location = noo_get_option( 'noo_show_resume_location_search',1);
$show_search_category = noo_get_option( 'noo_show_resume_category_search',1);
$search_keyword = isset( $_GET[ 's' ] ) ? $_GET[ 's' ] : '';
$location_args = array(
    'show_option_all' => __( 'All locations', 'noo' ),
    'hide_empty'      => 1,
    'echo'            => 1,
    'selected'        => isset( $_GET[ '_job_location' ] ) ? $_GET[ '_job_location' ] : '',
    'hierarchical'    => 1,
    'name'            => '_job_location',
    'id'              => 'noo-field-job_location',
    'class'           => 'noo-form-control noo-select form-control',
    'depth'           => 0,
    'taxonomy'        => 'job_location',
    'value_field'     => 'term',
    'orderby' => 'name',
    'walker'          => new Noo_Walker_TaxonomyDropdown(),
);
$categories_args = array(
    'show_option_all'  => __('All categories','noo'),
    'hide_empty'        => 1,
    'echo'              => 1,
    'selected'          => isset($_GET['_job_category']) ? $_GET['_job_category'] : '',
    'hierarchical'    => 1,
    'name'            => '_job_category',
    'id'              => 'noo-field-job_category',
    'class'           => 'noo-form-control noo-select form-control',
    'depth'           => 0,
    'taxonomy'        => 'job_category',
    'value_field'     => 'term',
    'orderby' => 'name',
    'walker'          => new Noo_Walker_TaxonomyDropdown(),
);

$noo_enable_parallax = noo_get_option( 'noo_enable_parallax', 1 );
$heading_image = get_page_heading_image();
?>
<header class="noo-page-heading noo-resume-heading"   style="background-image: url('<?php echo esc_url( $heading_img ); ?>');
<?php echo ( ! $noo_enable_parallax ) ? 'background: url(' . esc_url( $heading_image ) . ') no-repeat center center; -webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover;' : 'background: rgba(67, 67, 67, 0.55);'; ?> ">
    <div class="container-boxed max">
        <?php if ( noo_get_option( 'resume_search_form', 1 ) ) : ?>
            <div class="noo-heading-search">
                <form id="noo-heading-search-form" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <div class="row">
                        <div class="col-sm-4">
                            <label class="noo-form-label">
                                <?php echo esc_html__( 'Search Resume Now:', 'noo' ); ?>
                            </label>
                            <input type="text" name="s" class="noo-form-control"
                                   value="<?php echo esc_attr( $search_keyword ); ?>"
                                   placeholder="<?php echo esc_html__( 'Enter keywords...', 'noo' ); ?>">
                        </div>
                        <?php if($show_search_location):?>
                            <div class="col-sm-3">
                                <label class="noo-form-label">
                                    <?php echo esc_html__( 'Location:', 'noo' ); ?>
                                </label>
                                <?php wp_dropdown_categories( $location_args ); ?>
                            </div>
                        <?php endif;?>
                        <?php if($show_search_category):?>
                            <div class="col-sm-3">
                                <label class="noo-form-label">
                                    <?php echo esc_html__('Category','noo'); ?>
                                </label>
                                <?php wp_dropdown_categories($categories_args) ?>
                            </div>
                        <?php endif;?>
                        <div class="col-sm-2">
                            <label>&nbsp;</label>
                            <button style="display: block;" type="submit"
                                    class="btn btn-primary noo-btn-search"><?php echo esc_html__( 'Search', 'noo' ); ?></button>
                        </div>
                    </div>
                    <input type="hidden" class="form-control" name="post_type" value="noo_resume"/>
                </form>

                <?php if ( ! empty( $heading_text ) ): ?>
                    <div class="noo-search-html">
                        <?php echo $heading_text; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: list( $heading ) = get_page_heading();?>
            <h1 class="page-title"><?php echo esc_html($heading);?></h1>
        <?php endif; ?>
    </div><!-- /.container-boxed -->
    <?php if ( ! empty( $heading_image ) ) : ?>
        <?php if ( $noo_enable_parallax ) : ?>
            <div class="parallax" data-parallax="1" data-parallax_no_mobile="1" data-velocity="0.1"
                 style="background-image: url(<?php echo esc_url( $heading_image ); ?>); background-position: 50% 0; background-repeat: no-repeat;"></div>
        <?php endif; ?>
    <?php endif; ?>
</header>