function JM_Bing_Map(){
	
	var jm_location = jQuery('.job-map');
	if (jm_location.length > 0) {
		jm_location.each(function(index, el){
			var form_map   = jQuery(this),
				id_map     = form_map.find('.bmap').data('id'),
				zoom       = parseInt(form_map.find('.bmap').data('zoom')),
				lat        = parseFloat(form_map.find('.bmap').data('latitude')) ,
				lng        = parseFloat(form_map.find('.bmap').data('longitude')) ;
			var map = new Microsoft.Maps.Map(document.getElementById(id_map), {
	        	/* No need to set credentials if already passed in URL */
	            center: new Microsoft.Maps.Location(lat, lng),
	            zoom:zoom,
	            disableScrollWheelZoom: true,
	        });

            form_map.find('.gmap-loading').hide();

            var markers = JSON.parse(nooJobGmapL10n.marker_data);

            var company_markers = JSON.parse(nooJobGmapL10n.marker_company_data);

            dataLayer = new Microsoft.Maps.EntityCollection();
			map.entities.push(dataLayer);

			var infoboxLayer = new Microsoft.Maps.EntityCollection();
            map.entities.push(infoboxLayer);

            infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0), { visible: false, offset: new Microsoft.Maps.Point(0, 20) });
            infoboxLayer.push(infobox);

            // get_list_company_markers(map ,company_markers );

            get_list_markers(map, markers,company_markers );


            function get_list_markers(map, markers ,company_markers){
				Microsoft.Maps.loadModule("Microsoft.Maps.Clustering", function () {
					var pins = [];
					var icon_company = nooJobGmapL10n.theme_uri + '/assets/images/map-marker-icon.png'
					var icon = nooJobGmapL10n.theme_uri + '/assets/images/map-marker.png';
					for (var i = 0; i < company_markers.length; i++ ) {
						if ((company_markers[i]['latitude']=='') && (company_markers[i]['longitude']=='')) {
							continue;
						};
						var pin_company = new Microsoft.Maps.Pushpin(new Microsoft.Maps.Location(company_markers[i].latitude, company_markers[i].longitude),{icon:icon_company});
						pin_company.Title = '<h6><a href="' + company_markers[i].company_url + '">' + company_markers[i].title + '</a></h6>';
						pin_company.Description = '<div class="">\
							<div class="loop-item-wrap"> \
								<div class="item-featured"><a href="' + company_markers[i].company_url + '">' + company_markers[i].image + '</a></div> \
								<div class="loop-item-content"> \
								 	<h6 class="loop-item-title"><a href="' + company_markers[i].company_url + '">' + company_markers[i].title + '</a></h6>\
								 	<p class="content-meta">\
									<span class="job-company"> ' + company_markers[i].slogan + '</span>\
									<strong> Total Jobs: </strong><span class="total-job">'+ company_markers[i].total_job +'</span> \
									</p>\
							</div></div>';	 	
						Microsoft.Maps.Events.addHandler(pin_company, 'click', displayInfobox);		 	
			          	Microsoft.Maps.Events.addHandler(pin_company, 'click', (args) => {map.setView({center:args.target.getLocation(),zoom:13});} );
						pin_company.metadata = company_markers[i];
						pins.push(pin_company);
					}
					for (var j = 0; j < markers.length; j++ ) {
						if ((markers[j]['latitude']=='') && (markers[j]['longitude']=='')) {
							continue;
						};
						
						var pin = new Microsoft.Maps.Pushpin(new Microsoft.Maps.Location(markers[j].latitude, markers[j].longitude),{icon:icon});
						pin.Title = '<h6><a href="' + markers[j].url + '">' + markers[j].title + '</a></h6>';
						pin.Description = '<div>\
							<div class="loop-item-wrap"> \
								<div class="item-featured"><a href="' + markers[j].url + '">' + markers[j].image + '</a></div> \
								<div class="loop-item-content"> \
								 	<h6 class="loop-item-title"><a href="' + markers[j].url + '">' + markers[j].title + '</a></h6>\
								 	<p class="content-meta">';
						if (markers[j].company_url !== ''  || markers[j].company !== '') {
							pin.Description += '<span class="job-company"> <a href="' + markers[j].company_url + '">' + markers[j].company + '</a></span>';
						}		 	
						if (markers[j].type !== "") {
							pin.Description += '<span class="job-type"> <a href="' + markers[j].type_url + '" style="color: ' + markers[j].type_color + '"><i class="fa fa-bookmark"></i>' + markers[j].type + '</a></span> ';
						}			
						pin.Description +='</p>\
							</div></div>';

						Microsoft.Maps.Events.addHandler(pin, 'click', displayInfobox);	
						Microsoft.Maps.Events.addHandler(pin, 'click', (args) => {map.setView({center:args.target.getLocation(),zoom:13});} );
						// dataLayer.push(pin);	 	
						pin.metadata = markers[j];
						pins.push(pin);
					}
					var clusterLayer = new Microsoft.Maps.ClusterLayer(pins, {
			            clusteredPinCallback: customizeClusteredPin
			        });
			        map.layers.insert(clusterLayer);
				});	
			}
			function displayInfobox(e) {
			  if (e.targetType == 'pushpin') {
			      infobox.setLocation(e.target.getLocation());
			      infobox.setOptions({ visible: true, description: e.target.Description , maxWidth:350, maxHeight:220 });
			  }
			}

			function customizeClusteredPin(cluster) {
				var minRadius = 25 ;

				var url = nooJobGmapL10n.theme_uri + '/assets/images/cloud.png';
				var clusterSize = cluster.containedPushpins.length;
				var radius = Math.log(clusterSize) / Math.log(10) * 5 + minRadius;
				cluster.setOptions({
			        icon: url,
			        textOffset: new Microsoft.Maps.Point(0, radius -5)
			    });
			    // Add click event to clustered pushpin
			    Microsoft.Maps.Events.addHandler(cluster, 'click', pushpinClicked);
			}

			function pushpinClicked(e) {
			    //Show an infobox when a pushpin is clicked.
			    if (e.target.containedPushpins) {
			    var locs = [];
			    for (var i = 0, len = e.target.containedPushpins.length; i < len; i++) {
			        //Get the location of each pushpin.
			        locs.push(e.target.containedPushpins[i].getLocation());
			    }
			        //Create a bounding box for the pushpins.
			        var bounds = Microsoft.Maps.LocationRect.fromLocations(locs);
			        //Zoom into the bounding box of the cluster. 
			        //Add a padding to compensate for the pixel area of the pushpins.
			        map.setView({ bounds: bounds, padding: 100 });
			        if (bounds.width == 0) {
			        	showInfobox(e.target);
			        }
			    }			    
			}

			function showInfobox(pin) {
			    var description = [];

			    //Check to see if the pushpin is a cluster.
			    if (pin.containedPushpins) {
			        //Create a list of all pushpins that are in the cluster.
			        description.push('<div style="overflow-y:auto;"><ul class="bmap-listCluster">');
			        for (var i = 0; i < pin.containedPushpins.length; i++) {
			        	if (pin.containedPushpins[i].metadata.post_type == 'company') {
			        		description.push('<li><h6><i class="fa fa-suitcase" aria-hidden="true"></i><a href="'+pin.containedPushpins[i].metadata.company_url+'">', pin.containedPushpins[i].metadata.company, '</a></h6><div><a href="'+pin.containedPushpins[i].metadata.company_url+'">'+pin.containedPushpins[i].metadata.image+'</a><span>Total Jobs:'+pin.containedPushpins[i].metadata.total_job+'</span></div></li>');
			        	}
			        	if (pin.containedPushpins[i].metadata.post_type == 'job') {
			        		description.push('<li><h6><i class="fa fa-black-tie" aria-hidden="true"></i><a href="'+pin.containedPushpins[i].metadata.url+'">', pin.containedPushpins[i].metadata.title, '</a></h6><div><a href="'+pin.containedPushpins[i].metadata.company_url+'">'+pin.containedPushpins[i].metadata.image+''+pin.containedPushpins[i].metadata.company+'</a><span class="job-type" ><a href="'+pin.containedPushpins[i].metadata.type_url+'"style="color:'+pin.containedPushpins[i].metadata.type_color+'"><i class="fa fa-bookmark"></i>'+pin.containedPushpins[i].metadata.type+'</a></span></div></li>');
			        	}
			        }
			        description.push('</ul></div>');
			    }

			    //Display an infobox for the pushpin.
			    infobox.setOptions({
			        title: pin.getTitle(),
			        location: pin.getLocation(),
			        description: description.join(''),
			        visible: true,
			        maxWidth:320, 
			        maxHeight:280
			    });
			}

		});
	}
}


