<?php
/**************************************************************************************************
|
| iDocScript - Document Sharing Script
| http://www.idocscript.com
| webmaster@idocscript.com
|
|**************************************************************************************************
|
| By using this software you agree that you have read and acknowledged our End-User License 
| Agreement available at http://www.idocscript.com/eula.html and to be bound by it.
|
| Copyright (c) 2011 iDocScript.com. All rights reserved.
|**************************************************************************************************/

include("include/config.php");
include("include/functions/import.php");
$thebaseurl = $config['baseurl'];

$mainmenu = "5";
STemplate::assign('mainmenu',$mainmenu);

extract($_REQUEST);
if ($upload_id) {
	$data = uploadprogress_get_info($upload_id);
	if (!$data)
		$data['error'] = $lang['682'];
	else {		
		$avg_kb = $data['speed_average'] / 1024;
		if ($avg_kb<100)
			$avg_kb = round($avg_kb,1);
		else if ($avg_kb<10)
			$avg_kb = round($avg_kb,2);
		else $avg_kb = round($avg_kb);
		$data['kb_average'] = $avg_kb;
		$data['kb_uploaded'] = round($data['bytes_uploaded'] /1024);
	}
	echo json_encode($data);
	exit;
}

function genUploadKey ($length = 11) 
{ 
    $charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"; 
    for ($i=0; $i<$length; $i++) $key .= $charset[(mt_rand(0,(strlen($charset)-1)))]; 
    return $key; 
}

$USERID = intval(cleanit($_SESSION['USERID']));
if ($USERID != "" && $USERID >= 0 && is_numeric($USERID))
{
	if ($config['verify_upload'] != "0")
	{
		if ($_SESSION['VERIFIED'] != "1")
		{
			$error = $lang['685'];
			$error2 = "1";
			STemplate::assign('error2',$error2);
		}
	}
	
	$upload_id = genUploadKey();
	STemplate::assign('upload_id',$upload_id);
	
	if($_REQUEST['UPLOAD_IDENTIFIER'] != "")
	{
		$dtitle = cleanit($_REQUEST['dtitle']);
		$desc = cleanit($_REQUEST['desc']);
		$tags = cleanit($_REQUEST['tags']);
		$category = intval(cleanit($_REQUEST['category']));
		$public = intval(cleanit($_REQUEST['public']));
		$allowcomments = intval(cleanit($_REQUEST['allowcomments']));
		$allowratings = intval(cleanit($_REQUEST['allowratings']));
		$allowembeds = intval(cleanit($_REQUEST['allowembeds']));
		$allowdownloads = intval(cleanit($_REQUEST['allowdownloads']));
		$upload_file = $_FILES['doc_file']['name'];
		$pos = strrpos($upload_file,".");
		$ph = strtolower(substr($upload_file,$pos+1,strlen($upload_file)-$pos));
		$uploadedimage = $_FILES['thumb']['tmp_name'];
			
		STemplate::assign('dtitle',$dtitle);
		STemplate::assign('desc',$desc);
		STemplate::assign('tags',$tags);
		STemplate::assign('category',$category);
		STemplate::assign('public',$public);
		STemplate::assign('allowcomments',$allowcomments);
		STemplate::assign('allowratings',$allowratings);
		STemplate::assign('allowembeds',$allowembeds);
		STemplate::assign('allowdownloads',$allowdownloads);
		
		if($dtitle == "")
		{
			$error = $lang['459'];	
		}
		elseif($desc == "")
		{
			$error = $lang['461'];	
		}
		elseif($tags == "")
		{
			$error = $lang['460'];	
		}
		elseif($category == "0")
		{
			$error = $lang['462'];	
		}
		elseif($ph!="pdf" && $ph!="doc" && $ph!="xls" && $ph!="ppt")
		{
			$error = $lang['666']." ".$lang['667'];	
		}
				
		if($error == "")
		{
			$approve_docs = $config['approve_docs'];
			if($approve_docs == 1) 
			{
				$active = "active='0'";
			} 
			else 
			{
				$active = "active='1'";
			}			
			
			$query = "INSERT INTO docs SET USERID='".mysql_real_escape_string($USERID)."', title='".mysql_real_escape_string($dtitle)."', description='".mysql_real_escape_string($desc)."', tags='".mysql_real_escape_string($tags)."', categories='".mysql_real_escape_string($category)."', public='".mysql_real_escape_string($public)."', time_added='".time()."', date_added='".date("Y-m-d")."', $active, allowcomments='".mysql_real_escape_string($allowcomments)."', allowratings='".mysql_real_escape_string($allowratings)."', allowembeds='".mysql_real_escape_string($allowembeds)."', allowdownloads='".mysql_real_escape_string($allowdownloads)."'";
			$conn->execute($query);
			$did = mysql_insert_id();
			
			$original = $config['docdir']."/".$did.".".$ph;
			$uploaded = $_FILES['doc_file']['tmp_name'];
			move_uploaded_file($uploaded, $original);
			
			if(file_exists($original))
			{
				generate_doc_thumbs($did);	
				$oname = $did.".".$ph;
				$upload_file_size = filesize($original);
				$space = round($upload_file_size/(1024*1024));
				$query = "UPDATE docs SET original_doc='$oname', doc_name='$oname', filesize='$space' WHERE DID='".mysql_real_escape_string($did)."'";
				$conn->execute($query);
				
				$message = $lang['121'];
				STemplate::assign('dtitle',"");
				STemplate::assign('desc',"");
				STemplate::assign('tags',"");
				STemplate::assign('category',"");
				STemplate::assign('public',"");
				STemplate::assign('allowcomments',"");
				STemplate::assign('allowratings',"");
				STemplate::assign('allowembeds',"");
				STemplate::assign('allowdownloads',"");
				
				if($uploadedimage != "")
				{
					$theimageinfo = getimagesize($uploadedimage);
					$thepp = $did;
				
					if($theimageinfo[2] == 1)
					{
						$thepp .= ".gif";
					}
					elseif($theimageinfo[2] == 2)
					{
						$thepp .= ".jpg";
					}
					elseif($theimageinfo[2] == 3)
					{
						$thepp .= ".png";
					}	
					$myvideoimgnew=$config['tmpimgpath']."/".$thepp;
					if (file_exists($myvideoimgnew))
					{
						@unlink($myvideoimgnew);
					}
					$myconvertimg = $_FILES['thumb']['tmp_name'];
					move_uploaded_file($myconvertimg, $myvideoimgnew);
					create_thumbnail2($myvideoimgnew, $did);
				}
				else
				{
					if($ph == "pdf")
					{
						exec("mkdir ".$config['tmpimgpath']."/".$did);
						$dfolder = $config['tmpimgpath']."/".$did."/";
						$doutput = $dfolder.$did.".png";
						exec("convert $original $doutput");
						$screen2 = $dfolder.$did."-0.png";
						if(file_exists($doutput))
						{
							create_thumbnail2($doutput, $did);
						}
						elseif(file_exists($screen2))
						{
							create_thumbnail2($screen2, $did);
						}
						exec("rm -rf ".$dfolder);
					}
				}
				generate_mini_thumbs($did);
			}
		}
	}
}
else
{
	$redirect = base64_encode($thebaseurl."/upload");
	header("Location:$config[baseurl]/login.php?redirect=$redirect");exit;
}

STemplate::assign('pagetitle',$lang['42']);
STemplate::assign('error',$error);
STemplate::assign('message',$message);
STemplate::display('header.tpl');
STemplate::display('upload.tpl');
STemplate::display('footer.tpl');
?>