<?php
/**************************************************************************************************
|
| iDocScript - Document Sharing Script
| http://www.idocscript.com
| webmaster@idocscript.com
|
|**************************************************************************************************
|
| By using this software you agree that you have read and acknowledged our End-User License 
| Agreement available at http://www.idocscript.com/eula.html and to be bound by it.
|
| Copyright (c) 2011 iDocScript.com. All rights reserved.
|**************************************************************************************************/

include("include/config.php");
include("include/functions/import.php");
$thebaseurl = $config['baseurl'];

$sortby = cleanit($_REQUEST['s']);
$filter = intval(cleanit($_REQUEST['f']));
$page = intval(cleanit($_REQUEST['page']));
$searchterm = cleanit($_REQUEST['q']);

if($searchterm != "")
{
	STemplate::assign('q',$searchterm);
	if ($sortby=="a")
	{
		$sort = "asc";
	}
	else
	{
		$sortby = "z";
		$sort = "desc";
	}
	
	if($page=="")
	{
		$page = "1";
	}
	$currentpage = $page;
	
	if ($page >=2)
	{
		$pagingstart = ($page-1)*$config['items_per_page'];
	}
	else
	{
		$pagingstart = "0";
	}
	
	$queryselected = "SELECT count(*) as total from docs WHERE public='1' AND active='1' AND (title like '%".mysql_real_escape_string($searchterm)."%' OR description like '%".mysql_real_escape_string($searchterm)."%' OR tags like '%".mysql_real_escape_string($searchterm)."%') order by rating $sort limit $config[maximum_results]";
	$query2 = "SELECT * from docs WHERE public='1' AND active='1' AND (title like '%".mysql_real_escape_string($searchterm)."%' OR description like '%".mysql_real_escape_string($searchterm)."%' OR tags like '%".mysql_real_escape_string($searchterm)."%') order by rating $sort limit $pagingstart, $config[items_per_page]";
	STemplate::assign('pagetitle',$searchterm." ".$lang['664']);
	$executequeryselected = $conn->Execute($queryselected);
	
	$totaldocs = $executequeryselected->fields['total'];
	if ($totaldocs > 0)
	{
		if($executequeryselected->fields['total']<=$config['maximum_results'])
		{
			$total = $executequeryselected->fields['total'];
		}
		else
		{
			$total = $config['maximum_results'];
		}
		$toppage = ceil($total/$config['items_per_page']);
		if($toppage==0)
		{
			$xpage=$toppage+1;
		}
		else
		{
			$xpage = $toppage;
		}		
		$executequery2 = $conn->Execute($query2);
		$docs = $executequery2->getrows();
		$beginning=$pagingstart+1;
		$ending=$pagingstart+$executequery2->recordcount();
		$pagelinks="";
		$k=1;
		$theprevpage=$currentpage-1;
		$thenextpage=$currentpage+1;
		$added = "q=$searchterm&page=";
		if ($currentpage > 0)
		{
			
			if($currentpage > 1) 
			{
			$pagelinks.="<a href='$thebaseurl/search?".$added."1' class='page'>$lang[611]</a>";
			$pagelinks.="<a href='$thebaseurl/search?".$added."$theprevpage' class='page'>$lang[612]</a>";
			};
			
			$counter=0;
			
			$lowercount = $currentpage-5;
			if ($lowercount <= 0) $lowercount = 1;
			
			while ($lowercount < $currentpage)
			{
				$pagelinks.="<a href='$thebaseurl/search?".$added."$lowercount' class='page'>$lowercount</a>";
				$lowercount++;
				$counter++;
			}
			
			$pagelinks.="<span class='current'>$currentpage</span>";
			
			$uppercounter = $currentpage+1;
			
			while (($uppercounter < $currentpage+10-$counter) && ($uppercounter<=$toppage))
			{
				$pagelinks.="<a href='$thebaseurl/search?".$added."$uppercounter' class='page'>$uppercounter</a>";
				$uppercounter++;
			}
			
			if($currentpage < $toppage) 
			{
			
			$pagelinks.="<a href='$thebaseurl/search?".$added."$thenextpage' class='page'>$lang[613]</a>";
			$pagelinks.="<a href='$thebaseurl/search?".$added."$toppage' title='last page' class='page'>$lang[614]</a>";
			}
		}
	}
	else
	{
		$error = $lang['665'];
	}
}
else
{
	STemplate::assign('pagetitle',$lang['660']);	
}

//TEMPLATES BEGIN
STemplate::assign('mainmenu',4);
STemplate::assign('error',$error);
STemplate::assign('pagelinks',$pagelinks);
STemplate::assign('docs',$docs);
STemplate::display('header.tpl');
STemplate::display('search.tpl');
STemplate::display('footer.tpl');
//TEMPLATES END
?>