<?php
/**************************************************************************************************
|
| iDocScript - Document Sharing Script
| http://www.idocscript.com
| webmaster@idocscript.com
|
|**************************************************************************************************
|
| By using this software you agree that you have read and acknowledged our End-User License 
| Agreement available at http://www.idocscript.com/eula.html and to be bound by it.
|
| Copyright (c) 2011 iDocScript.com. All rights reserved.
|**************************************************************************************************/

include("include/config.php");
include("include/functions/import.php");
$thebaseurl = $config['baseurl'];
$config['items_per_page'] = 24;
$mainmenu = "3";
STemplate::assign('mainmenu',$mainmenu);

$sortby = cleanit($_REQUEST['s']);
$filter = intval(cleanit($_REQUEST['f']));
$page = intval(cleanit($_REQUEST['page']));

if ($sortby=="a")
{
	$sort = "asc";
}
else
{
	$sortby = "z";
	$sort = "desc";
}
STemplate::assign('sortby',$sortby);

if($page=="")
{
	$page = "1";
}
$currentpage = $page;

if ($page >=2)
{
	$pagingstart = ($page-1)*$config['items_per_page'];
}
else
{
	$pagingstart = "0";
}

if ($filter =="0")
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' order by addtime $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' order by addtime $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[585]";
}
elseif ($filter =="1")
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' order by lastlogin $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' order by lastlogin $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[586]";
}
elseif ($filter =="2")
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' order by profileviews $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' order by profileviews $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[587]";
}
elseif ($filter =="3")
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' order by docsyouviewed $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' order by docsyouviewed $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[588]";
}
elseif ($filter =="4")
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' AND featured='1' order by username $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' AND featured='1' order by username $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[165]";
}
else
{
	$query1 = "SELECT count(*) as total from members WHERE status='1' order by addtime $sort limit $config[maximum_results]";
	$query2 = "SELECT * from members WHERE status='1' order by addtime $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[585]";
}
STemplate::assign('showtitle',$showtitle);
STemplate::assign('pagetitle',$showtitle);
STemplate::assign('filter',$filter);

$executequery1 = $conn->Execute($query1);

$totaldocs = $executequery1->fields['total'];
if ($totaldocs > 0)
{

	if($executequery1->fields['total']<=$config[maximum_results])
	{
		$total = $executequery1->fields['total'];
	}
	else
	{
		$total = $config[maximum_results];
	}
	
	$toppage = ceil($total/$config[items_per_page]);
	if($toppage==0)
	{
		$xpage=$toppage+1;
	}
	else
	{
		$xpage = $toppage;
	}
	
	
	$executequery2 = $conn->Execute($query2);
	$m = $executequery2->getrows();
	$beginning=$pagingstart+1;
	$ending=$pagingstart+$executequery2->recordcount();
	
	$pagelinks="";
	$k=1;
	$theprevpage=$currentpage-1;
	$thenextpage=$currentpage+1;
	$added = "s=$sortby&f=$filter&page=";
	if ($currentpage > 0)
	{
		if($currentpage > 1) 
		{
			$pagelinks.="<a href='$thebaseurl/members?".$added."1' class='page'>$lang[611]</a>";
			$pagelinks.="<a href='$thebaseurl/members?".$added."$theprevpage' class='page'>$lang[612]</a>";
		}
		$counter=0;
		$lowercount = $currentpage-5;
		if ($lowercount <= 0) $lowercount = 1;
		while ($lowercount < $currentpage)
		{
			$pagelinks.="<a href='$thebaseurl/members?".$added."$lowercount' class='page'>$lowercount</a>";
			$lowercount++;
			$counter++;
		}
		$pagelinks.="<span class='current'>$currentpage</span>";
		$uppercounter = $currentpage+1;
		while (($uppercounter < $currentpage+10-$counter) && ($uppercounter<=$toppage))
		{
			$pagelinks.="<a href='$thebaseurl/members?".$added."$uppercounter' class='page'>$uppercounter</a>";
			$uppercounter++;
		}
		if($currentpage < $toppage) 
		{
			$pagelinks.="<a href='$thebaseurl/members?".$added."$thenextpage' class='page'>$lang[613]</a>";
			$pagelinks.="<a href='$thebaseurl/members?".$added."$toppage' title='last page' class='page'>$lang[614]</a>";
		}
	}
}
else
{
	$error = $lang['591'];
}

//TEMPLATES BEGIN
STemplate::assign('error',$error);
STemplate::assign('pagelinks',$pagelinks);
STemplate::assign('m',$m);
STemplate::display('header.tpl');
STemplate::display('members.tpl');
STemplate::display('footer.tpl');
//TEMPLATES END
?>