<?php
/**************************************************************************************************
|
| iDocScript - Document Sharing Script
| http://www.idocscript.com
| webmaster@idocscript.com
|
|**************************************************************************************************
|
| By using this software you agree that you have read and acknowledged our End-User License 
| Agreement available at http://www.idocscript.com/eula.html and to be bound by it.
|
| Copyright (c) 2011 iDocScript.com. All rights reserved.
|**************************************************************************************************/

include("include/config.php");
include("include/functions/import.php");
$thebaseurl = $config['baseurl'];

$mainmenu = "1";
STemplate::assign('mainmenu',$mainmenu);

$sortby = cleanit($_REQUEST['s']);
$filter = intval(cleanit($_REQUEST['f']));
$page = intval(cleanit($_REQUEST['page']));

if ($sortby=="a")
{
	$sort = "asc";
}
else
{
	$sortby = "z";
	$sort = "desc";
}
STemplate::assign('sortby',$sortby);

if($page == "0")
{
	$page = "1";
}
$currentpage = $page;

if ($page >=2)
{
	$pagingstart = ($page-1)*$config['items_per_page'];
}
else
{
	$pagingstart = "0";
}

if ($filter =="0")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by time_added $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by time_added $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[674]";
	$submenu = "0";
}
elseif ($filter =="1")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by viewcount $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by viewcount $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[675]";
	$submenu = "1";
}
elseif ($filter =="2")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by rating $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by rating $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[676]";
	$submenu = "2";
}
elseif ($filter =="3")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by commentcount $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by commentcount $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[677]";
	$submenu = "3";
}
elseif ($filter =="4")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by favoritecount $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by favoritecount $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[678]";
	$submenu = "4";
}
elseif ($filter =="6")
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' AND featured='1' order by time_added $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' AND featured='1' order by time_added $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[215]";
	$submenu = "6";
}
else
{
	$query1 = "SELECT count(*) as total from docs where public='1' AND active='1' order by time_added $sort limit $config[maximum_results]";
	$query2 = "SELECT DID,title from docs where public='1' AND active='1' order by time_added $sort limit $pagingstart, $config[items_per_page]";
	$showtitle = "$lang[674]";
	$submenu = "0";
}
STemplate::assign('showtitle',$showtitle);
STemplate::assign('pagetitle',$showtitle);
STemplate::assign('filter',$filter);
STemplate::assign('submenu',$submenu);

$executequery1 = $conn->Execute($query1);

$totaldocs = $executequery1->fields['total'];
if ($totaldocs > 0)
{
	if($executequery1->fields['total']<=$config['maximum_results'])
	{
		$total = $executequery1->fields['total'];
	}
	else
	{
		$total = $config['maximum_results'];
	}
	
	$toppage = ceil($total/$config['items_per_page']);
	if($toppage==0)
	{
		$xpage=$toppage+1;
	}
	else
	{
		$xpage = $toppage;
	}
	
	$executequery2 = $conn->Execute($query2);
	$docs = $executequery2->getrows();
	$beginning=$pagingstart+1;
	$ending=$pagingstart+$executequery2->recordcount();
	
	$pagelinks="";
	$k=1;
	$theprevpage=$currentpage-1;
	$thenextpage=$currentpage+1;
	$added = "s=$sortby&f=$filter&page=";
	if ($currentpage > 0)
	{
		
		if($currentpage > 1) 
		{
		$pagelinks.="<a href='$thebaseurl/docs?".$added."1' class='page'>$lang[611]</a>";
		$pagelinks.="<a href='$thebaseurl/docs?".$added."$theprevpage' class='page'>$lang[612]</a>";
		};
		
		$counter=0;
		
		$lowercount = $currentpage-5;
		if ($lowercount <= 0) $lowercount = 1;
		
		while ($lowercount < $currentpage)
		{
			$pagelinks.="<a href='$thebaseurl/docs?".$added."$lowercount' class='page'>$lowercount</a>";
			$lowercount++;
			$counter++;
		}
		
		$pagelinks.="<span class='current'>$currentpage</span>";
		
		$uppercounter = $currentpage+1;
		
		while (($uppercounter < $currentpage+10-$counter) && ($uppercounter<=$toppage))
		{
			$pagelinks.="<a href='$thebaseurl/docs?".$added."$uppercounter' class='page'>$uppercounter</a>";
			$uppercounter++;
		}
		
		if($currentpage < $toppage) 
		{
		
		$pagelinks.="<a href='$thebaseurl/docs?".$added."$thenextpage' class='page'>$lang[613]</a>";
		$pagelinks.="<a href='$thebaseurl/docs?".$added."$toppage' title='last page' class='page'>$lang[614]</a>";
		}
	}
}
else
{
	$error = $lang['692'];
}

//TEMPLATES BEGIN
STemplate::assign('error',$error);
STemplate::assign('pagelinks',$pagelinks);
STemplate::assign('docs',$docs);
STemplate::display('header.tpl');
STemplate::display('docs.tpl');
STemplate::display('footer.tpl');
//TEMPLATES END
?>