<?php

/* setup includes */
require_once('includes/master.inc.php');

/* received params */
if (!$fontId = (int) $_REQUEST['font'])
{
    header("HTTP/1.0 404 Not Found");
    die();
}

if (!$fontObj = new font($fontId))
{
    header("HTTP/1.0 404 Not Found");
    die();
}

$file = $_REQUEST['file'];
if (!$file = base64_decode($file))
{
    header("HTTP/1.0 404 Not Found");
    die();
}

/* safely does it! */
$file = str_replace(array("/", "\\", "\"", "'"), "", $file);

/* load up requested file */
$filePath = FONTS_UNPACKED_ARCHIVE . $fontId . "/" . $file;

if (!file_exists($filePath))
{
    header("HTTP/1.0 404 Not Found");
    die();
}

/* output file */
$contents = file_get_contents($filePath);
if (font::getFileExtension($file) == "txt")
{
    $contents = nl2br($contents);
}
echo $contents;
