<?php

/* setup includes */
require_once('includes/master.inc.php');

$page = $_REQUEST['page'];
if (!$page)
{
    $page = 1;
}

$perPage = font::getFontsPerPageSetting();

/* total items */
$overallTotal = $db->getValue("SELECT COUNT(id) AS total FROM font WHERE fontRating IS NOT NULL AND status = 'active'");

$pageTitle = t("top_rated_fonts");

/* setup page */
define("PAGE_NAME", $pageTitle);
define("PAGE_KEY", "top_rated");
define("PAGE_DESCRIPTION", t("top_rated_meta_description"));
define("PAGE_KEYWORDS", t("top_rated_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');

/* title section */
echo htmlHelpers::createPageTitleHTML($pageTitle);

echo "<div class='pageMainContent'>";

/* main body */
$limitedRS = $db->getRows("SELECT * FROM font WHERE fontRating IS NOT NULL AND status = 'active' ORDER BY fontRating DESC, fontName LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
$tracker   = 1;
$totalRows = COUNT($limitedRS);
if (COUNT($limitedRS))
{
    foreach ($limitedRS AS $fontRow)
    {
        echo fontPreviewBlock::createHTMLBlock($fontRow);

        if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
        {
            if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
            {
                echo '<div class="inlinePageAds">';
                echo SITE_CONFIG_ADVERT_INLINE_LISTING;
                echo '</div>';
            }

            $tracker++;
        }
    }
}
else
{
    echo "<ul><li>" . t("no_top_rated_fonts") . "</strong></li></ul>";
}

echo "</div>";

/* paging */
echo htmlHelpers::createPagingBlock(WEB_ROOT . "/top_rated/", $overallTotal, $page);
?>
<?php

require_once('_footer.php');
?>