<?php
/* setup includes */
require_once('includes/master.inc.php');

/* include mailer class */
require_once(DOC_ROOT . '/includes/phpMailer/class.phpmailer.php');

/* font preview template block */
require_once('_font_preview_block.inc.php');

$authorEmail = (($Auth->loggedIn()==true)?$Auth->user->email:'');
$fontCategories = array();
$fontLicense = 1;
$urlWebsite = '';
/* manage any submissions */
if ((int) $_REQUEST['submitme'])
{
    /* get params */
    $fontName       = trim($_REQUEST['fontName']);
    $authorEmail    = trim($_REQUEST['authorEmail']);
    $fontDesigner   = trim($_REQUEST['fontDesigner']);
    $fontCategories = $_REQUEST['fontCategories'];
    $fontFile       = $_FILES['fontFile'];
    $fontLicense = (int)$_REQUEST['fontLicense'];
    $urlWebsite   = strtolower(trim($_REQUEST['urlWebsite']));

    /* validation */
    if (strlen($authorEmail) == 0)
    {
        setError(t("please_enter_email_address"));
    }
    elseif (valid_email($authorEmail) == false)
    {
        setError(t("email_address_invalid"));
    }
    elseif (strlen($fontName) == 0)
    {
        setError(t("please_enter_font_name"));
    }
    elseif (strlen($fontDesigner) == 0)
    {
        setError(t("please_enter_the_designer"));
    }
    elseif (COUNT($fontCategories) == 0)
    {
        setError(t("please_select_category"));
    }
    elseif (strlen($fontFile['name']) == 0)
    {
        setError(t("please_attach_zip_archive"));
    }
    elseif (font::getFileExtension($fontFile['name']) != "zip")
    {
        setError(t("font_archive_not_zip"));
    }

    if (!isErrors())
    {
        // tidy
        if(substr($urlDesigner, 0, 3) == 'www')
        {
            $urlDesigner = 'http://'.$urlDesigner;
        }
        
        /* add the font to the system */
        $dbInsert = new DBObject("font", array("fontName", "fontDesigner", "dateCreated", "status", "submissionIpAddress", "licenseId", "urlWebsite", "submittedUserId"));
        $dbInsert->fontName = $fontName;
        $dbInsert->fontDesigner = $fontDesigner;
        $dbInsert->dateCreated = sqlDateTime();
        $dbInsert->submissionIpAddress = getUsersIPAddress();
        $dbInsert->status = "pending";
        $dbInsert->licenseId = $fontLicense;
        $dbInsert->urlWebsite = $urlWebsite;
        $dbInsert->submittedUserId = (($Auth->loggedIn()==true)?$Auth->id:0);
        $dbInsert->insert();
        if (!$dbInsert->id)
        {
            setError("Failed to submit font, please try again later.");
        }
        else
        {
            $newZipFilename = $dbInsert->id;

            /* insert categories */
            foreach ($fontCategories AS $fontCategory)
            {
                $dbInsertCat = new DBObject("font_categories_join", array("fontId", "categoryId"));
                $dbInsertCat->fontId = $newZipFilename;
                $dbInsertCat->categoryId = $fontCategory;
                $dbInsertCat->insert();
            }

            /* move uploaded font archive */
            $newZipFilePath = FONTS_ARCHIVE_FOLDER . $newZipFilename . ".zip";
            rename($fontFile['tmp_name'], $newZipFilePath);

            $mail = new PHPMailer(true);
            try
            {
                $mail->AddAddress(SITE_CONFIG_SITE_SUPPORT_EMAIL, "Admin - " . SITE_CONFIG_SITE_NAME);
                $mail->SetFrom($authorEmail, $fontDesigner);
                $mail->Subject = 'New font submitted on ' . SITE_CONFIG_SITE_NAME;
                $mail->MsgHTML("Dear Admin,<br/><br/>A new font has been submitted on " . SITE_CONFIG_SITE_NAME . ". Please log into the font admin area and approve/decline the new font.:<br/><br/><strong>From Email:</strong> " . $authorEmail . "<br/><strong>Font Name:</strong> " . $fontName . "<br/><strong>Font Designer:</strong> " . $fontDesigner);
                $mail->Send();
            }
            catch (phpmailerException $e)
            {
                //setError($e->getMessage());
            }
            catch (Exception $e)
            {
                //setError($e->getMessage());
            }
            redirect("submit_font_thanks." . SITE_CONFIG_PAGE_EXTENSION);
        }
    }
}

/* setup page */
define("PAGE_NAME", t("submit_font_page_name"));
define("PAGE_KEY", "submit_font");
define("PAGE_DESCRIPTION", t("submit_font_meta_description"));
define("PAGE_KEYWORDS", t("submit_font_meta_keywords"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML(t("submit_font"));

echo "<div class='pageMainContent'>";

/* main body */
echo t("submit_font_intro");
echo "<br/><br/>";

/* form */
echo outputErrors();
?>
<div class="clear"><!-- --></div>

<div class="submitFontForm">
    <form name="submitFont" id="submitFont" method="POST" action="submit_font.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" enctype="multipart/form-data">

        <label for="authorEmail"><?php echo t("your_email_address"); ?>:</label>
        <div>
            <input name="authorEmail" id="authorEmail" value="<?php echo safeOutputToScreen($authorEmail); ?>" type="text"/>
        </div>

        <label for="fontName"><?php echo t("font_name_submit"); ?>:</label>
        <div>
            <input name="fontName" id="fontName" value="<?php echo safeOutputToScreen($_REQUEST['fontName']); ?>" type="text"/>
        </div>

        <label for="fontDesigner"><?php echo t("font_designer_submit"); ?>:</label>
        <div>
            <input name="fontDesigner" id="fontDesigner" value="<?php echo safeOutputToScreen($_REQUEST['fontDesigner']); ?>" type="text"/>
        </div>
        
        <label for="urlWebsite"><?php echo t("website_url_optional", "Website Url (optional)"); ?>:</label>
        <div>
            <input name="urlWebsite" id="urlWebsite" value="<?php echo safeOutputToScreen($_REQUEST['urlWebsite']); ?>" type="text"/>
        </div>

        <label for="fontCategories"><?php echo t("suggested_categories"); ?></label>
        <div>
            <select name="fontCategories[]" id="fontCategories" multiple size="12">
                <?php
                $cats = $db->getRows("SELECT id, categoryName FROM font_categories ORDER BY categoryName");
                foreach ($cats AS $cat)
                {
                    echo "<option value=\"" . $cat['id'] . "\"";
                    if (in_array($cat['id'], $fontCategories))
                    {
                        echo " SELECTED";
                    }
                    echo ">" . ($cat['categoryName']) . "</option>";
                }
                ?>
            </select>
        </div>

        <label for="fontFile"><?php echo t("font_archive_submit"); ?></label>
        <div>
            <input name="fontFile" id="fontFile" type="file"/>
        </div>

        <label for="fontLicense"><?php echo t("font_license", "Font License"); ?></label>
        <div>
            <select name="fontLicense" id="fontLicense">
                <?php
                $licenses = $db->getRows("SELECT id, label FROM font_license ORDER BY label");
                foreach ($licenses AS $license)
                {
                    echo "<option value=\"" . $license['id'] . "\"";
                    if ($license['id'] == $fontLicense)
                    {
                        echo " SELECTED";
                    }
                    echo ">" . ($license['label']) . "</option>";
                }
                ?>
            </select>
        </div>

        <label for="submitButton">&nbsp;</label>
        <div>
            <input name="submitme" id="submitme" type="hidden" value="1"/>
            <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("submit_font_submit"); ?>"/>
        </div>
    </form>
</div>
<?php
echo "</div>";
?>

<?php
require_once('_footer.php');
?>