<?php

/* setup includes */
require_once('includes/master.inc.php');

/* pickup variables */
$q    = strip_tags(trim($_REQUEST['q']));
$d    = (int) $_REQUEST['d'];
$page = (int) $_REQUEST['page'];

if ($d)
{
    $sQLClause = "WHERE fontDesigner LIKE '" . $db->escape($q) . "%'";
}
else
{
    $sQLClause = "WHERE (fontName LIKE '%" . $db->escape($q) . "%' || fontDesigner LIKE '%" . $db->escape($q) . "%')";
}
$sQLClause .= " AND status = 'active' ";

if (!$page)
{
    $page    = 1;
}
$perPage = font::getFontsPerPageSetting();

/* total items */
$overallTotal = $db->getValue("SELECT COUNT(id) AS total FROM font " . $sQLClause);
$pageTitle    = t("search_results") . " " . safeOutputToScreen($q);

/* setup page */
define("PAGE_NAME", $pageTitle);
define("PAGE_DESCRIPTION", t("search_meta_description"));
define("PAGE_KEYWORDS", t("search_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<?php

/* title section */
echo htmlHelpers::createPageTitleHTML($pageTitle, $overallTotal . " results");

echo "<div class='pageMainContent'>";

/* main body */
$limitedRS = $db->getRows("SELECT * FROM font " . $sQLClause . " LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
$tracker   = 1;
$totalRows = COUNT($limitedRS);
if (COUNT($limitedRS))
{
    foreach ($limitedRS AS $fontRow)
    {
        echo fontPreviewBlock::createHTMLBlock($fontRow);

        if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
        {
            if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
            {
                echo '<div class="inlinePageAds">';
                echo SITE_CONFIG_ADVERT_INLINE_LISTING;
                echo '</div>';
            }

            $tracker++;
        }
    }
}
else
{
    echo "<ul><li>" . t("no_search_results") . " <strong>" . safeOutputToScreen($q) . "</strong></li></ul>";
}

echo "</div>";

/* paging */
echo htmlHelpers::createPagingBlock(WEB_ROOT . "/search." . SITE_CONFIG_PAGE_EXTENSION . "?q=" . urlencode($q) . "&d=" . urlencode($d) . "&page=", $overallTotal, $page);
?>

<?php

require_once('_footer.php');
?>