<?php

/* setup includes */
require_once('includes/master.inc.php');

$rssTitle = 'Latest Fonts';
header("Content-Type: application/xml; charset=ISO-8859-1");
$rssfeed = '<?xml version="1.0" encoding="ISO-8859-1"?>';
$rssfeed .= '<rss version="2.0">';
$rssfeed .= '<channel>';
$rssfeed .= '<title>MFScripts Release History - ' . UCWords($rssTitle) . '</title>';
$rssfeed .= '<link>http://'._CONFIG_SITE_FULL_URL.'</link>';
$rssfeed .= '<description>Latest fonts on '._CONFIG_SITE_HOST_URL.'</description>';
$rssfeed .= '<language>en-us</language>';
$rssfeed .= '<copyright>Copyright (C) ' . date('Y') . ' '._CONFIG_SITE_HOST_URL.'</copyright>';

$db = Database::getDatabase();
$limitedRS = $db->getRows("SELECT * FROM font WHERE status = 'active' ORDER BY dateCreated DESC LIMIT 20");
foreach ($limitedRS AS $row)
{
    $rssfeed .= '<item>';
    $rssfeed .= '<title><![CDATA[' . $row['fontName'] . ']]></title>';
    $rssfeed .= '<description><![CDATA[' . strip_tags(trim($row['fontName'])) . ' by '.(strlen($row['fontDesigner'])?strip_tags(trim($row['fontDesigner'])):'Unknown').']]></description>';
    $rssfeed .= '<link>' . font::createFontDetailsUrl($row['id'], $row['fontName']) . '</link>';
    $rssfeed .= '<pubDate>' . date("D, d M Y H:i:s O", strtotime($row['dateCreated'])) . '</pubDate>';
    $rssfeed .= '</item>';
}

$rssfeed .= '</channel>';
$rssfeed .= '</rss>';

echo $rssfeed;