<?php
/* setup includes */
require_once('includes/master.inc.php');

/* include mailer class */
require_once(DOC_ROOT . '/includes/phpMailer/class.phpmailer.php');

/* register user */
$title               = '';
$firstname           = '';
$lastname            = '';
$emailAddress        = '';
$emailAddressConfirm = '';
$username            = '';
if ((int) $_REQUEST['submitme'])
{
    // validation
    $title               = trim($_REQUEST['title']);
    $firstname           = trim($_REQUEST['firstname']);
    $lastname            = trim($_REQUEST['lastname']);
    $emailAddress        = trim(strtolower($_REQUEST['emailAddress']));
    $emailAddressConfirm = trim(strtolower($_REQUEST['emailAddressConfirm']));
    $username            = trim(strtolower($_REQUEST['username']));

    if (!strlen($title))
    {
        setError(t("please_enter_your_title", "Please enter your title"));
    }
    elseif (!strlen($firstname))
    {
        setError(t("please_enter_your_firstname", "Please enter your firstname"));
    }
    elseif (!strlen($lastname))
    {
        setError(t("please_enter_your_lastname", "Please enter your lastname"));
    }
    elseif (!strlen($emailAddress))
    {
        setError(t("please_enter_your_email_address", "Please enter your email address"));
    }
    elseif ($emailAddress != $emailAddressConfirm)
    {
        setError(t("your_email_address_confirmation_does_not_match", "Your email address confirmation does not match"));
    }
    elseif (!valid_email($emailAddress))
    {
        setError(t("your_email_address_is_invalid", "Your email address is invalid"));
    }
    elseif (!strlen($username))
    {
        setError(t("please_enter_your_preferred_username", "Please enter your preferred username"));
    }
    elseif ((strlen($username) < 6) || (strlen($username) > 20))
    {
        setError(t("username_must_be_between_6_and_20_characters", "Your username must be between 6 and 20 characters"));
    }
    elseif (!valid_username($username))
    {
        setError(t("your_username_is_invalid", "Your username can only contact alpha numeric and underscores."));
    }
    else
    {
        $checkEmail = UserPeer::loadUserByEmailAddress($emailAddress);
        if ($checkEmail)
        {
            // username exists
            setError(t("email_address_already_exists", "Email address already exists on another account"));
        }
        else
        {
            $checkUser = UserPeer::loadUserByUsername($username);
            if ($checkUser)
            {
                // username exists
                setError(t("username_already_exists", "Username already exists on another account"));
            }
        }
    }
    
    if ((!isErrors()) && (SITE_CONFIG_SHOW_CAPTCHA == 'show'))
    {
        // check captcha
        if (md5($_REQUEST['captchaText']) != $_SESSION['captcha_text'])
        {
            setError(t("failed_captcha", "The captcha text you've entered is incorrect, please try again."));
        }
    }

    // create the account
    if (!isErrors())
    {
        $newPassword = createPassword();
        $newUser     = UserPeer::create($username, $newPassword, $emailAddress, $title, $firstname, $lastname);
        if ($newUser)
        {
            $subject = t('register_user_email_subject', 'Account details for [[[SITE_NAME]]]', array('SITE_NAME' => SITE_CONFIG_SITE_NAME));

            $replacements = array(
                'FIRST_NAME'    => $firstname,
                'SITE_NAME'     => SITE_CONFIG_SITE_NAME,
                'WEB_ROOT'      => WEB_ROOT,
                'USERNAME'      => $username,
                'PASSWORD'      => $newPassword
            );
            $defaultContent = "Dear [[[FIRST_NAME]]],<br/><br/>";
            $defaultContent .= "Your account on [[[SITE_NAME]]] has been created. Use the details below to login to your new account:<br/><br/>";
            $defaultContent .= "<strong>Url:</strong> <a href='[[[WEB_ROOT]]]'>[[[WEB_ROOT]]]</a><br/>";
            $defaultContent .= "<strong>Username:</strong> [[[USERNAME]]]<br/>";
            $defaultContent .= "<strong>Password:</strong> [[[PASSWORD]]]<br/><br/>";
            $defaultContent .= "Feel free to contact us if you need any support with your account.<br/><br/>";
            $defaultContent .= "Regards,<br/>";
            $defaultContent .= "[[[SITE_NAME]]] Admin";
            $htmlMsg        = t('register_user_email_content', $defaultContent, $replacements);

            send_html_mail($emailAddress, $subject, $htmlMsg, SITE_CONFIG_DEFAULT_EMAIL_ADDRESS_FROM, strip_tags(str_replace("<br/>", "\n", $htmlMsg)));

            // for non upgrades
            redirect(WEB_ROOT . "/register_complete." . SITE_CONFIG_PAGE_EXTENSION);
        }
        else
        {
            setError(t("problem_creating_your_account_try_again_later", "There was a problem creating your account, please try again later"));
        }
    }
}

/* setup page */
define("PAGE_NAME", t("register_page_name", "Register"));
define("PAGE_KEY", "register");
define("PAGE_DESCRIPTION", t("register_meta_description", "Register to manage your saved fonts"));
define("PAGE_KEYWORDS", t("register_meta_keywords", "register,manage,your,saved,fonts"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML(t("register", "Register"));
?>

<div class='pageMainContent'>

    <?php
    /* main body */
    echo t("use_form_to_register_for_an_account", "Please enter your information below to register for an account. Your new account password will be sent to your email address.") . "<br/><br/>";

    /* form */
    echo outputErrors();
    ?>
    <div class="clear"><!-- --></div>

    <div class="submitFontForm">
        <form name="loginForm" id="loginForm" method="POST" action="register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">
            <label for="title"><?php echo t("title", "title"); ?></label>
            <div>
                <select autofocus="autofocus" tabindex="1" id="title" name="title" class="uiStyle" style="width: 100px;">
                    <option value="Mr" <?php echo ($title == 'Mr') ? 'SELECTED' : ''; ?>><?php echo t('title_mr', 'Mr'); ?></option>
                    <option value="Mrs" <?php echo ($title == 'Mrs') ? 'SELECTED' : ''; ?>><?php echo t('title_mrs', 'Mrs'); ?></option>
                    <option value="Miss" <?php echo ($title == 'Miss') ? 'SELECTED' : ''; ?>><?php echo t('title_miss', 'Miss'); ?></option>
                    <option value="Dr" <?php echo ($title == 'Dr') ? 'SELECTED' : ''; ?>><?php echo t('title_dr', 'Dr'); ?></option>
                    <option value="Pro" <?php echo ($title == 'Pro') ? 'SELECTED' : ''; ?>><?php echo t('title_pro', 'Pro'); ?></option>
                </select>
            </div>

            <label for="firstname"><?php echo t("firstname", "Firstname"); ?>:</label>
            <div>
                <input name="firstname" id="firstname" value="<?php echo safeOutputToScreen($firstname); ?>" type="text"/>
            </div>

            <label for="lastname"><?php echo t("lastname", "Lastname"); ?>:</label>
            <div>
                <input name="lastname" id="lastname" value="<?php echo safeOutputToScreen($lastname); ?>" type="text"/>
            </div>

            <label for="emailAddress"><?php echo t("email_address", "Email Address"); ?>:</label>
            <div>
                <input name="emailAddress" id="emailAddress" value="<?php echo safeOutputToScreen($emailAddress); ?>" type="text"/>
            </div>

            <label for="emailAddressConfirm"><?php echo t("emailAddressConfirm", "Email Address Confirm"); ?>:</label>
            <div>
                <input name="emailAddressConfirm" id="email_address_confirm" value="<?php echo safeOutputToScreen($emailAddressConfirm); ?>" type="text"/>
            </div>

            <label for="username"><?php echo t("username", "Username"); ?>:</label>
            <div>
                <input name="username" id="username" value="<?php echo safeOutputToScreen($username); ?>" type="text"/>
            </div>
            
            <?php if (SITE_CONFIG_SHOW_CAPTCHA == 'show'): ?>
                <label for='captchaText'><?php echo UCWords(t("captcha", "Confirm Text")); ?>:</label>
                <div style='float: left; padding: 0px;'>
                    <input name='captchaText' id='captchaText' type='text' value='' style='width: 170px;'>
                </div>
                <div style='float: left; padding: 0px;'>
                    <img src='<?php echo WEB_ROOT; ?>/captcha.php' />
                </div>
                <div style="clear: both;"><!-- --></div>
            <?php endif; ?>

            <label for="submitButton">&nbsp;</label>
            <div>
                <input name="submitme" id="submitme" type="hidden" value="1"/>
                <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("register", "register"); ?>"/>
            </div>
        </form>
    </div>
</div>

<?php
require_once('_footer.php');
?>