DROP TABLE `stats`;
CREATE TABLE IF NOT EXISTS `stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `referer` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `referer_is_local` tinyint(4) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `img_search` tinyint(4) NOT NULL DEFAULT '0',
  `browser_family` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `browser_version` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `os` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `os_version` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `base_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dt` (`dt`),
  KEY `page_title` (`page_title`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=122;
INSERT INTO stats (dt, page_title, ip) SELECT dateCreated, fontId, ipAddress FROM download;

CREATE TABLE IF NOT EXISTS `plugin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(150) COLLATE utf8_bin NOT NULL,
  `folder_name` varchar(100) COLLATE utf8_bin NOT NULL,
  `plugin_description` varchar(255) COLLATE utf8_bin NOT NULL,
  `is_installed` int(1) NOT NULL DEFAULT '0',
  `date_installed` datetime NOT NULL,
  `plugin_settings` text COLLATE utf8_bin NOT NULL,
  `plugin_enabled` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=13 ;

UPDATE `site_config` SET `availableValues` = '["yes","no"]' WHERE `site_config`.`id` =22;
UPDATE `site_config` SET `availableValues` = '["key","translation"]' WHERE `site_config`.`id` =21;
UPDATE `site_config` SET `availableValues` = '["yes","no"]' WHERE `site_config`.`id` =27;
UPDATE `site_config` SET `availableValues` = '["yes","no"]' WHERE `site_config`.`id` =23;

ALTER TABLE `language` ADD `isLocked` INT( 1 ) NOT NULL;
UPDATE `language` SET `isLocked` = '1' WHERE `language`.`id` =1;
ALTER TABLE `language` ADD `flag` VARCHAR( 20 ) NOT NULL;
UPDATE `language` SET `flag` = 'us' WHERE `language`.`id` =1;
UPDATE `language_content` SET content = REPLACE(content , ':', '') WHERE languageId=1;
UPDATE `language_key` SET defaultContent = REPLACE(defaultContent, ':', '');

ALTER TABLE `font` ADD `submittedUserId` INT( 11 ) NOT NULL;

ALTER TABLE `font` ADD INDEX ( `fontDesigner` );
ALTER TABLE `font` ADD INDEX ( `status` );
ALTER TABLE `font` ADD INDEX ( `totalDownloads` );
ALTER TABLE `font` ADD INDEX ( `fontRating` );
ALTER TABLE `font` ADD INDEX ( `submittedUserId` );

ALTER TABLE `font_comment` ADD `emailAddress` VARCHAR( 255 ) NOT NULL AFTER `comment`;
CREATE TABLE `font_license` (`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY, `label` VARCHAR(200) NOT NULL) ENGINE = MyISAM;
INSERT INTO `font_license` (`id`, `label`) VALUES (NULL, 'Free for Personal Use'), (NULL, 'Free');
INSERT INTO `font_license` (`id`, `label`) VALUES (NULL, 'Donationware'), (NULL, 'Demo');
INSERT INTO `font_license` (`id`, `label`) VALUES (NULL, 'Unknown'), (NULL, 'Public domain, GPL, OFL');
INSERT INTO `font_license` (`id`, `label`) VALUES (NULL, 'Shareware');

ALTER TABLE `font` ADD `licenseId` INT( 11 ) NOT NULL;
UPDATE font SET licenseId = (SELECT id FROM font_license WHERE label='Free for Personal Use');
ALTER TABLE `font`  ADD `urlWebsite` TEXT NOT NULL,  ADD `urlProfile` TEXT NOT NULL,  ADD `urlBlog` TEXT NOT NULL;
INSERT INTO `site_config` (`id`, `config_key`, `config_value`, `config_description`, `availableValues`, `config_type`, `config_group`) VALUES (NULL, 'bad_words_list', 'example bad 1|example bad 2', 'Comments will not be allows if they contain any of these words. Separate with a pipe character (|).', '', 'textarea', 'Comments');
INSERT INTO `site_config` VALUES(NULL, 'default_email_address_from', 'email@yoursite.com', 'The default email address to send emails from.', '', 'string', 'Page Options');
ALTER TABLE `users` ADD `datecreated` DATETIME NOT NULL;
ALTER TABLE `users` ADD `createdip` VARCHAR( 15 ) NOT NULL;
ALTER TABLE `users` ADD `passwordResetHash` VARCHAR( 32 ) NOT NULL;
ALTER TABLE `download` ADD `userId` INT( 11 ) NOT NULL;
ALTER TABLE `download` ADD INDEX ( `fontId` );
ALTER TABLE `download` ADD INDEX ( `userId` );

INSERT INTO `site_config` (`id`, `config_key`, `config_value`, `config_description`, `availableValues`, `config_type`, `config_group`) VALUES (NULL, 'show_captcha', 'show', 'Show or hide the captcha confirmation on forms.', '["show","hide"]', 'select', 'Page Options');
