<?php
/* setup includes */
require_once('includes/master.inc.php');

/* include mailer class */
require_once(DOC_ROOT . '/includes/phpMailer/class.phpmailer.php');

/* login user */
if ((int) $_REQUEST['submitme'])
{
    // do login
    $loginUsername = trim($_REQUEST['loginUsername']);
    $loginPassword = trim($_REQUEST['loginPassword']);

    if (!strlen($loginUsername))
    {
        setError(t("please_enter_your_username", "Please enter your username"));
    }
    elseif (!strlen($loginPassword))
    {
        setError(t("please_enter_your_password", "Please enter your password"));
    }
    else
    {
        $rs = $Auth->login($loginUsername, $loginPassword);
        if ($rs)
        {
            // successful login
            redirect(WEB_ROOT . '/account_home.'.SITE_CONFIG_PAGE_EXTENSION);
        }
        else
        {
            // login failed
            setError(t("username_and_password_is_invalid", "Your username and password are invalid"));
        }
    }
}

/* setup page */
define("PAGE_NAME", t("login_page_name", "Login"));
define("PAGE_KEY", "login");
define("PAGE_DESCRIPTION", t("login_meta_description", "Login to manage your saved fonts"));
define("PAGE_KEYWORDS", t("login_meta_keywords", "login,manage,your,saved,fonts"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML(t("Login", "Login"));
?>

<div class='pageMainContent'>

<?php
/* main body */
echo t("use_form_to_login_to_your_account", "Use the form below to login to your account.") . "<br/><br/>";

/* form */
echo outputErrors();
?>
<div class="clear"><!-- --></div>

<div class="submitFontForm">
    <form name="loginForm" id="loginForm" method="POST" action="login.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">
        <label for="loginUsername"><?php echo t("your_username", "Your Username"); ?>:</label>
        <div>
            <input name="loginUsername" id="loginUsername" value="<?php echo safeOutputToScreen($_REQUEST['loginUsername']); ?>" type="text"/>
        </div>

        <label for="loginPassword"><?php echo t("password", "password"); ?>:</label>
        <div>
            <input name="loginPassword" id="loginPassword" value="" type="password"/>
        </div>

        <label for="submitButton">&nbsp;</label>
        <div>
            <input name="submitme" id="submitme" type="hidden" value="1"/>
            <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("login", "login"); ?>"/>
        </div>
        
        <label for="loginPassword">&nbsp;</label>
        <div>
            <br/>(<a href="forgot_password.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><?php echo t("forgot_password", "forgot password"); ?>)
        </div>
    </form>
</div>
</div>

<?php
require_once('_footer.php');
?>