<?php

/* setup includes */
require_once('includes/master.inc.php');

/* setup page */
define("PAGE_NAME", t("index_page_name"));
define("PAGE_KEY", "index");
define("PAGE_DESCRIPTION", t("index_meta_description"));
define("PAGE_KEYWORDS", t("index_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');

// newest fonts
echo htmlHelpers::createPageTitleHTML(t("latest_fonts", "Latest Fonts"));

echo "<div class='pageMainContent'>";
$limitedRS = $db->getRows("SELECT * FROM font WHERE status = 'active' ORDER BY dateCreated DESC LIMIT 5");
$tracker   = 1;
$totalRows = COUNT($limitedRS);
foreach ($limitedRS AS $fontRow)
{
    echo fontPreviewBlock::createHTMLBlock($fontRow);

    if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
    {
        if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
        {
            echo '<div class="inlinePageAds">';
            echo SITE_CONFIG_ADVERT_INLINE_LISTING;
            echo '</div>';
        }

        $tracker++;
    }
}
echo "</div>";

// most popular fonts
echo htmlHelpers::createPageTitleHTML(t("most_popular_fonts", "Most Popular Fonts"));

echo "<div class='pageMainContent'>";
$limitedRS = $db->getRows("SELECT * FROM font WHERE status = 'active' ORDER BY totalDownloads DESC LIMIT 5");
$tracker   = 1;
$totalRows = COUNT($limitedRS);
foreach ($limitedRS AS $fontRow)
{
    echo fontPreviewBlock::createHTMLBlock($fontRow);

    if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
    {
        if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
        {
            echo '<div class="inlinePageAds">';
            echo SITE_CONFIG_ADVERT_INLINE_LISTING;
            echo '</div>';
        }

        $tracker++;
    }
}
echo "</div>";

require_once('_footer.php');
