<?php
/* setup includes */
require_once('includes/master.inc.php');

// check for pending hash
$userId       = (int) $_REQUEST['u'];
$passwordHash = $_REQUEST['h'];
$user         = UserPeer::loadUserByPasswordResetHash($passwordHash);
if (!$user)
{
    redirect(WEB_ROOT);
}

// check user id passed is valid
if($user->id != $userId)
{
    redirect(WEB_ROOT);
}

/* handle forgot password */
$success = false;
if ((int) $_REQUEST['submitme'])
{
    // validation
    $password        = trim($_REQUEST['password']);
    $confirmPassword = trim($_REQUEST['confirmPassword']);
    if (!strlen($password))
    {
        setError(t("please_enter_your_password", "Please enter your new password"));
    }
    elseif ((strlen($password) < 6) || (strlen($password) > 20))
    {
        setError(t("password_length_incorrect", "Password should be between 6 - 20 characters in length"));
    }
    elseif (containsInvalidCharacters(strtolower($password, 'abcdefghijklmnopqrstuvwxyz1234567890@~#!-_£$&*()^%}{()')))
    {
        setError(t("password_contains_illegal_characters", "Password contains invalid characters, please choose another."));
    }
    elseif ($password != $confirmPassword)
    {
        setError(t("password_confirmation_does_not_match", "Your password confirmation does not match"));
    }

    // create the account
    if (!isErrors())
    {
        // update password
        $db = Database::getDatabase(true);
	$db->query('UPDATE users SET passwordResetHash = "", password = :password WHERE id = :id', array('password' => MD5($password), 'id' => $userId));
        
        // success
        $success = true;
    }
}

/* setup page */
define("PAGE_NAME", t("forgot_password_reset_page_name", "Forgot Password - Reset"));
define("PAGE_DESCRIPTION", t("forgot_password_reset_meta_description", "Forgot Password - Reset"));
define("PAGE_KEYWORDS", t("forgot_password_reset_meta_keywords", "forgot,password,manage,your,saved,fonts"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML(t("forgot_password_reset", "Forgot Password - Reset"));
?>

<div class='pageMainContent'>

<?php
/* main body */
echo t("use_form_to_login_to_your_account", "Use the form below to login to your account.") . "<br/><br/>";

/* form */
echo outputErrors();
?>
<div class="clear"><!-- --></div>

<?php if ($success === true): ?>
    <p class="introText">
        <?php echo t("forgot_password_reset_confirm_intro_text", "Your password has been reset. You can now login to the site above."); ?>
    </p>
<?php else: ?>
    <div class="submitFontForm">
        <form name="loginForm" id="loginForm" method="POST" action="forgot_password_reset.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" autocomplete="off">
            <label for="password"><?php echo t("password", "Password"); ?>:</label>
            <div>
                <input name="password" id="password" value="" type="password"/>
            </div>

            <label for="confirmPassword"><?php echo t("confirm_password", "Confirm Password"); ?>:</label>
            <div>
                <input name="confirmPassword" id="confirmPassword" value="" type="password"/>
            </div>

            <label for="submitButton">&nbsp;</label>
            <div>
                <input name="submitme" id="submitme" type="hidden" value="1"/>
                <input type="hidden" value="<?php echo (int) $userId; ?>" name="u"/>
                <input type="hidden" value="<?php echo safeOutputToScreen($passwordHash); ?>" name="h"/>
                <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("update_password", "update password"); ?>"/>
            </div>
        </form>
    </div>
<?php endif; ?>

</div>

<?php
require_once('_footer.php');
?>