<?php
/* setup includes */
require_once('includes/master.inc.php');

/* include mailer class */
require_once(DOC_ROOT . '/includes/phpMailer/class.phpmailer.php');

/* send password reset */
if ((int) $_REQUEST['submitme'])
{
    // validation
    $emailAddress = trim(strtolower($_REQUEST['emailAddress']));
    if (!strlen($emailAddress))
    {
        setError(t("please_enter_your_email_address", "Please enter the account email address"));
    }
    else
    {
        $checkEmail = UserPeer::loadUserByEmailAddress($emailAddress);
        if (!$checkEmail)
        {
            // username exists
            setError(t("account_not_found", "Account with that email address not found"));
        }
    }

    // create the account
    if (!isErrors())
    {
        $userAccount = UserPeer::loadUserByEmailAddress($emailAddress);
        if ($userAccount)
        {
            // create password reset hash
            $resetHash = UserPeer::createPasswordResetHash($userAccount->id);

            $subject = t('forgot_password_email_subject', 'Password reset instructions for account on [[[SITE_NAME]]]', array('SITE_NAME' => SITE_CONFIG_SITE_NAME));

            $replacements = array(
                'FIRST_NAME'     => $userAccount->firstname,
                'SITE_NAME'      => SITE_CONFIG_SITE_NAME,
                'WEB_ROOT'       => WEB_ROOT,
                'USERNAME'       => $username,
                'PAGE_EXTENSION' => SITE_CONFIG_PAGE_EXTENSION,
                'ACCOUNT_ID'     => $userAccount->id,
                'RESET_HASH'     => $resetHash
            );
            $defaultContent  = "Dear [[[FIRST_NAME]]],<br/><br/>";
            $defaultContent .= "We've a request to reset your password on [[[SITE_NAME]]]. Follow the url below to set a new account password:<br/><br/>";
            $defaultContent .= "<a href='[[[WEB_ROOT]]]/forgot_password_reset.[[[PAGE_EXTENSION]]]?u=[[[ACCOUNT_ID]]]&h=[[[RESET_HASH]]]'>[[[WEB_ROOT]]]/forgot_password_reset.[[[PAGE_EXTENSION]]]?u=[[[ACCOUNT_ID]]]&h=[[[RESET_HASH]]]</a><br/><br/>";
            $defaultContent .= "If you didn't request a password reset, just ignore this email and your existing password will continue to work.<br/><br/>";
            $defaultContent .= "Regards,<br/>";
            $defaultContent .= "[[[SITE_NAME]]] Admin";
            $htmlMsg         = t('forgot_password_email_content', $defaultContent, $replacements);

            send_html_mail($emailAddress, $subject, $htmlMsg, SITE_CONFIG_DEFAULT_EMAIL_ADDRESS_FROM, strip_tags(str_replace("<br/>", "\n", $htmlMsg)));
            redirect(WEB_ROOT . "/forgot_password." . SITE_CONFIG_PAGE_EXTENSION . "?s=1");
        }
    }
}

/* setup page */
define("PAGE_NAME", t("forgot_password_page_name", "Forgot Password"));
define("PAGE_DESCRIPTION", t("forgot_password_meta_description", "Retrieve your account password."));
define("PAGE_KEYWORDS", t("forgot_password_meta_keywords", "forgot,password,members,area,fonts"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML(t("forgot_password", "Forgot Password"));
?>

<div class='pageMainContent'>

    <?php
    /* main body */
    echo t("use_form_to_reset_your_account_password", "Enter your email address below to receive further instructions on how to reset your account password.") . "<br/><br/>";

    /* form */
    echo outputErrors();
    ?>
    <div class="clear"><!-- --></div>

    <?php if (isset($_REQUEST['s'])): ?>
        <p class="introText">
            <?php echo t("forgot_password_sent_intro_text", "An email has been sent with further instructions on how to reset your password. Please check your email inbox."); ?>
        </p>
    <?php else: ?>
    <div class="submitFontForm">
        <form name="resetPasswordForm" id="resetPasswordForm" method="POST" action="forgot_password.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">
            <label for="emailAddress"><?php echo t("email_address", "Email Address"); ?>:</label>
            <div>
                <input name="emailAddress" id="emailAddress" value="<?php echo isset($emailAddress) ? safeOutputToScreen($emailAddress) : ''; ?>" type="text"/>
            </div>

            <label for="submitButton">&nbsp;</label>
            <div>
                <input name="submitme" id="submitme" type="hidden" value="1"/>
                <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("request_reset", "request reset"); ?>"/>
            </div>
        </form>
    </div>
    <?php endif; ?>
</div>

<?php
require_once('_footer.php');
?>