<?php
/* setup includes */
require_once('includes/master.inc.php');

if (!$fontId = (int) $_REQUEST['f'])
{
    header("HTTP/1.0 404 Not Found");
    die();
}

$fontObj = new font($fontId);
if (!$fontObj->fontId)
{
    header("HTTP/1.0 404 Not Found");
    die();
}

if ((!$fontObj->dataData['status'] != "active") && (!$fontObj->dataData['status'] != "pending"))
{
    header("HTTP/1.0 404 Not Found");
    die();
}

// load license
$licenseLabel = $db->getValue("SELECT label FROM font_license WHERE id=" . (int) $fontObj->fontData['licenseId']);

// hide 'more details' button on preview
define('HIDE_MORE_DETAILS', true);

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* deal with comment submit */
$success = false;
if ((int) $_REQUEST['submitme'])
{
    $comment = trim($_REQUEST['comment']);
    $comment = strip_tags($comment);
    $comment = str_replace(array("\"", "'"), "", $comment);
    $comment = str_replace("\n", " ", $comment);

    $userName = trim($_REQUEST['userName']);
    $userName = strip_tags($userName);
    $userName = str_replace(array("\"", "'"), "", $userName);
    $userName = str_replace("\n", " ", $userName);

    $emailAddress = trim($_REQUEST['emailAddress']);
    $emailAddress = strip_tags($emailAddress);
    $emailAddress = str_replace(array("\"", "'"), "", $emailAddress);
    $emailAddress = str_replace("\n", " ", $emailAddress);

    if (strlen($userName) == 0)
    {
        setError(t("please_enter_full_name"));
    }
    elseif (strlen($emailAddress) == 0)
    {
        setError(t("please_enter_email_address", "Please enter your email address"));
    }
    elseif (valid_email($emailAddress) == false)
    {
        setError(t("please_enter_valid_email_address", "Please enter a valid email address"));
    }
    elseif (strlen($comment) == 0)
    {
        setError(t("please_enter_your_comment"));
    }
    else
    {
        // check for banned words
        $matchFound = false;
        if (strlen(SITE_CONFIG_BAD_WORDS_LIST))
        {
            $matches = array();
            $matchFound = preg_match_all(
                    "/\b(" . SITE_CONFIG_BAD_WORDS_LIST . ")\b/i", $comment, $matches
            );

            if (!$matchFound)
            {
                $matchFound = preg_match_all(
                        "/\b(" . SITE_CONFIG_BAD_WORDS_LIST . ")\b/i", $userName, $matches
                );
            }
        }
        
        // match found
        if($matchFound == true)
        {
            setError(t("comment_contains_banned_words", "Your comment contains 1 or more banned words, please edit and try again."));
        }
    }
    
    if((!isErrors()) && (SITE_CONFIG_SHOW_CAPTCHA == 'show'))
    {
        // check captcha
        if (md5($_REQUEST['captchaText']) != $_SESSION['captcha_text'])
        {
            setError(t("failed_captcha", "The captcha text you've entered is incorrect, please try again."));
        }
    }

    if (!isErrors())
    {
        /* add comment */
        if (!fontcomment::createNewComment($fontId, $userName, $comment, "active", $emailAddress))
        {
            setError(t("problem_adding_comment"));
        }
        else
        {
            $url = font::createFontDetailsUrl($fontObj->fontId, $fontObj->fontData['fontName']) . "/1";
            redirect($url);
        }
    }
}

if ((int) $_REQUEST['success'])
{
    $success = true;
}

/* page title */
$pageTitle = $fontObj->fontData['fontName'] . " " . t("font_details");

/* setup page */
define("PAGE_NAME", $pageTitle);
define("PAGE_DESCRIPTION", $pageTitle . ". " . t("font_details_meta_description"));
define("PAGE_KEYWORDS", strtolower($fontObj->fontData['fontName']) . ", " . t("font_details_meta_keywords"));

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML($pageTitle);

echo "<div class='pageMainContent'>";

/* font preview */
echo fontPreviewBlock::createHTMLBlock($fontObj->fontData, true);

/* left section wrapper */
echo "<div class='pageDetailsLeft'>";
/* character map */
echo "	<div class='characterMap'>";
echo htmlHelpers::createPageTitleHTML(t("character_map"));
echo "		<img src='" . $fontObj->getCharacterMapUrl() . "' class='fontPreview' alt='" . t("character_map") . "'/>";
echo "	</div>";

/* file contents */
$extractedArchivePath = FONTS_UNPACKED_ARCHIVE . $fontObj->fontId . "/";
$archiveContents      = font::readDirectoryContents($extractedArchivePath);
if (COUNT($archiveContents))
{
    echo "	<div class='fontArchiveContents'>";
    echo htmlHelpers::createPageTitleHTML(t("file_contents"));
    echo "		<table width='100%' cellpadding='0' cellspacing='0'>";
    echo "			<thead><th>" . t("filename") . "</th><th style='width:110px; text-align:center;'>" . t("filesize") . "</th><th style='width:110px; text-align:center;'>" . t("type") . "</th><th style='width:70px; text-align:center;'>" . t("options") . "</th></thead>";
    foreach ($archiveContents AS $archiveContent)
    {
        $filesize = filesize($extractedArchivePath . $archiveContent);
        echo "<tr>";
        echo "	<td>" . $archiveContent . "</td>";
        echo "	<td style='text-align:center;'>" . bytes2str($filesize) . "</td>";
        echo "	<td style='text-align:center;'>" . font::getFileTypeBasedOnFilename($archiveContent) . "</td>";
        $url      = "&nbsp;";
        switch (font::getFileExtension($archiveContent))
        {
            case "ttf":
            case "otf":
                $url = "<a href='" . font::createFontDownloadUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']) . "'>" . t("download") . "</a>";
                break;
            case "txt":
            case "jpg":
            case "jpeg":
            case "png":
            case "gif":
                $url = "<a href='" . WEB_ROOT . "/view_file/" . $fontObj->fontId . "/" . base64_encode($archiveContent) . "/" . htmlHelpers::formatForUrl($archiveContent) . "' target='_blank'>" . t("view") . "</a>";
                break;
        }
        echo "	<td style='text-align:center;'>" . $url . "</td>";
        echo "</tr>";
    }
    echo "		</table>";
    echo "	</div>";
}
echo "	<div class='clear'><!-- --></div>";
echo "</div>";

/* right section wrapper */
echo "<div class='pageDetailsRight'>";

echo htmlHelpers::createPageTitleHTML(t("font", "Font"));
echo "<div class='clear'><!-- --></div>";
?>
<div class="fontDesigner">
    <table width="100%" cellspacing="0" cellpadding="0">
        <?php if (strlen($fontObj->fontData['fontDesigner'])): ?>
            <tr>
                <td style="width: 120px;">Designer Name:</td>
                <td><?php echo "<a href='" . WEB_ROOT . "/search." . SITE_CONFIG_PAGE_EXTENSION . "?d=1&q=" . urlencode(safeOutputToScreen($fontObj->fontData['fontDesigner'])) . "'>" . safeOutputToScreen($fontObj->fontData['fontDesigner']) . "</a>"; ?></td>
            </tr>
        <?php endif; ?>
        <?php if (strlen($licenseLabel)): ?>
            <tr>
                <td style="width: 120px;">License:</td>
                <td><?php echo $licenseLabel; ?></td>
            </tr>
        <?php endif; ?>
        <?php if (strlen($fontObj->fontData['urlWebsite'])): ?>
            <tr>
                <td>Website:</td>
                <td><a href="<?php echo safeOutputToScreen($fontObj->fontData['urlWebsite']); ?>" target="_blank"><?php echo safeOutputToScreen($fontObj->fontData['urlWebsite']); ?></a></td>
            </tr>
        <?php endif; ?>
        <?php if (strlen($fontObj->fontData['urlProfile'])): ?>
            <tr>
                <td>Profile:</td>
                <td><a href="<?php echo safeOutputToScreen($fontObj->fontData['urlProfile']); ?>" target="_blank"><?php echo safeOutputToScreen($fontObj->fontData['urlProfile']); ?></a></td>
            </tr>
        <?php endif; ?>
        <?php if (strlen($fontObj->fontData['urlBlog'])): ?>
            <tr>
                <td>Blog:</td>
                <td><a href="<?php echo safeOutputToScreen($fontObj->fontData['urlBlog']); ?>" target="_blank"><?php echo safeOutputToScreen($fontObj->fontData['urlBlog']); ?></a></td>
            </tr>
        <?php endif; ?>
    </table>
</div>
<div class='clear'><!-- --></div>

<?php
echo htmlHelpers::createPageTitleHTML(t("share_font", "Share Font"));
echo "<div class='clear'><!-- --></div>";
?>
<!-- AddThis Button BEGIN -->
<div class="addthis_toolbox addthis_default_style addthis_32x32_style">
    <a class="addthis_button_preferred_1" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
    <a class="addthis_button_preferred_2" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
    <a class="addthis_button_preferred_3" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
    <a class="addthis_button_preferred_4" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
    <a class="addthis_button_compact" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
    <a class="addthis_counter addthis_bubble_style" addthis:url="<?php echo font::createFontDetailsUrl($fontObj->fontData['id'], $fontObj->fontData['fontName']); ?>" addthis:title="<?php echo str_replace("\"", "", $fontObj->fontData['fontName']); ?>"></a>
</div>
<script type="text/javascript" src="http://s7.addthis.com/js/250/addthis_widget.js#pubid=xa-4f10918d56581527"></script>
<!-- AddThis Button END -->
<?php
if(SITE_CONFIG_ALLOW_COMMENTS == 'yes')
{
	echo "	<div class='userComments'>";

	/* list comments */
	$getComments = $db->getRows("SELECT * FROM font_comment WHERE fontId = " . (int) $fontObj->fontId . " AND status = 'active' ORDER BY dateCreated DESC LIMIT 50");
	if (COUNT($getComments))
	{
		$tracker       = 0;
		$totalComments = COUNT($getComments);
		echo "		<div class='userCommentsList'>";
		echo htmlHelpers::createPageTitleHTML(t("font_comments") . " (" . COUNT($getComments) . ")");
		foreach ($getComments AS $comment)
		{
			echo "<div class='commentsWrapper " . (($tracker == 0) ? "commentFirst" : "") . "'>";
			echo "	<div class='commentLeft'>";
			echo $totalComments - $tracker;
			echo "	</div>";
			echo "	<div class='commentRight'>";
			echo "		<div class='commentBody'>" . safeOutputToScreen($comment['comment']) . "</div>";
			echo "		<div class='commentHead'>" . dater($comment['dateCreated']) . " " . t("by") . " " . safeOutputToScreen($comment['userName']) . "</div>";
			echo "	</div>";
			echo "	<div class='clear'><!-- --></div>";
			echo "</div>";
			$tracker++;
		}
		echo "		</div>";
		echo "		<div class='clear'><!-- --></div>";
	}

	echo "		<div class='userCommentsForm'>";
	echo htmlHelpers::createPageTitleHTML(t("leave_comment"));
	if ($success)
	{
		echo "<ul class='pageSuccess'><li>" . t("comment_added_allow_24_hours") . "</li></ul>";
	}
	else
	{
		echo outputErrors();
	}
	echo "			<div class='clear'><!-- --></div>";
	echo "			<div class='userCommentsIntro'>" . t("enter_comments_about_font_below") . "</div>";
	echo "			<div class='clear'><!-- --></div>";
	echo "			<form method='POST' action='" . font::createFontDetailsUrl($fontObj->fontId, $fontObj->fontData['fontName']) . "'>";
	echo "				<div class='formLabel'><label for='userName'>" . UCWords(t("name")) . ":</label></div>";
	echo "				<input name='userName' id='userName' type='text' value='" . safeOutputToScreen(isset($_REQUEST['userName']) ? $_REQUEST['userName'] : '') . "'>";
	echo "				<div class='clear'><!-- --></div>";

	echo "				<div class='formLabel'><label for='emailAddress'>" . UCWords(t("email_address", "email address")) . ":</label></div>";
	echo "				<input name='emailAddress' id='emailAddress' type='text' value='" . safeOutputToScreen(isset($_REQUEST['emailAddress']) ? $_REQUEST['emailAddress'] : '') . "'>";
	echo "				<div class='clear'><!-- --></div>";

	echo "				<div class='formLabel'><label for='comment'>" . UCWords(t("comment")) . ":</label></div>";
	echo "				<textarea name='comment' id='comment'>" . safeOutputToScreen(isset($_REQUEST['comment']) ? $_REQUEST['comment'] : '') . "</textarea>";
	echo "				<div class='clear'><!-- --></div>";

	if(SITE_CONFIG_SHOW_CAPTCHA == 'show')
	{
		echo "				<div class='formLabel'><label for='captchaText'>" . UCWords(t("captcha", "Confirm Text")) . ":</label></div>";
		echo "                          <div style='float: left;'>";
		echo "                              <input name='captchaText' id='captchaText' type='text' value='' style='width: 170px;'>";
		echo "				</div>";
		echo "                          <div style='float: left;'>";
		echo "                              <img src='".WEB_ROOT."/captcha.php' />";
		echo "				</div>";
		echo "				<div class='clear'><!-- --></div>";
	}

	echo "				<div class='formLabel'>&nbsp;</div>";
	echo "				<input name='submitme' type='hidden' value='1'>";
	echo "				<input name='submit' id='submit' type='submit' value='" . t("post_comment") . "' class='submitButton'>";
	echo "				<div class='clear'><!-- --></div>";
	echo "			</form>";
	echo "		</div>";
	echo "	</div>";
	echo "</div>";

	echo "<div class='clear'><!-- --></div>";
}

echo "</div>";
?>
<!-- www.20script.ir -->
<?php
require_once('_footer.php');
?>