<?php

/* setup includes */
require_once('includes/master.inc.php');

/* require login */
if($Auth->loggedIn() == false)
{
    redirect(WEB_ROOT);
}


/* for non js users */
if (str_replace("/", "", $letter) == "-")
{
    $letter = "a";
    define("NO_JS_DISPLAY_BROWSE", true);
}

$page = (int)$_REQUEST['page'];
if (!$page)
{
    $page    = 1;
}
$perPage = font::getFontsPerPageSetting();

/* total items */
$overallTotal = $db->getValue("SELECT COUNT(DISTINCT download.fontId) AS total FROM font LEFT JOIN download ON font.id = download.fontId WHERE download.userId=".$Auth->id." AND font.status='active'");

/* setup page */
define("PAGE_NAME", t("your_downloads_page_name", "Your Downloads"));
define("PAGE_KEY", "downloads");
define("PAGE_DESCRIPTION", t("your_downloads_meta_description", "Your downloads"));
define("PAGE_KEYWORDS", t("your_downloads_meta_keywords", "your,downloads"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<?php

/* title section */
echo htmlHelpers::createPageTitleHTML(t("your_downloads_page_name", "Your Downloads"));

echo "<div class='pageMainContent'>";

if($overallTotal > 0)
{
    /* main body */
    $limitedRS = $db->getRows("SELECT font.* FROM font LEFT JOIN download ON font.id = download.fontId WHERE download.userId=".$Auth->id." AND font.status='active' GROUP BY download.fontId ORDER BY MAX(download.dateCreated) DESC LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
    $tracker   = 1;
    $totalRows = COUNT($limitedRS);
    foreach ($limitedRS AS $fontRow)
    {
        echo fontPreviewBlock::createHTMLBlock($fontRow);

        if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
        {
            if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
            {
                echo '<div class="inlinePageAds">';
                echo SITE_CONFIG_ADVERT_INLINE_LISTING;
                echo '</div>';
            }

            $tracker++;
        }
    }
}
else
{
    echo t("no_items_in_downloads", "You do not have any font download history.");
}

echo "</div>";

if($overallTotal > 0)
{
    /* paging */
    echo htmlHelpers::createPagingBlock(WEB_ROOT . "/downloads.".SITE_CONFIG_PAGE_EXTENSION."?page=", $overallTotal, $page);
}
?>

<?php

require_once('_footer.php');
?>