<?php

/* setup includes */
require_once('includes/master.inc.php');

// try to load queue font ids from session
$fontIds = array();
if (isset($_SESSION['download_queue']))
{
    $fontIds = explode(",", $_SESSION['download_queue']);
}

$page = (int) $_REQUEST['page'];
if (!$page)
{
    $page    = 1;
}
$perPage = font::getFontsPerPageSetting();

$overallTotal = 0;
if (strlen(trim(implode(",", $fontIds))))
{
    /* total items */
    $overallTotal = $db->getValue("SELECT COUNT(id) AS total FROM font WHERE id IN(0," . implode(",", $fontIds) . ") AND status='active'");
}

/* setup page */
define("PAGE_NAME", t("download_queue_page_name", "Download Queue"));
define("PAGE_DESCRIPTION", t("download_queue_meta_description", "Your download queue"));
define("PAGE_KEYWORDS", t("download_queue_meta_keywords", "your,download,queue"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<?php

/* title section */
echo htmlHelpers::createPageTitleHTML(t("your_download_queue_page_name", "Your Download Queue"));

echo "<div class='pageMainContent'>";

if ($overallTotal > 0)
{
    /* main body */
    $limitedRS = $db->getRows("SELECT * FROM font WHERE id IN(" . implode(",", $fontIds) . ") AND status='active' ORDER BY fontName LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
    $tracker   = 1;
    $totalRows = COUNT($limitedRS);
    foreach ($limitedRS AS $fontRow)
    {
        echo fontPreviewBlock::createHTMLBlock($fontRow);

        if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
        {
            if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
            {
                echo '<div class="inlinePageAds">';
                echo SITE_CONFIG_ADVERT_INLINE_LISTING;
                echo '</div>';
            }

            $tracker++;
        }
    }
}
else
{
    echo t("no_items_in_queue", "There are no items in your download queue.");
}

echo "</div>";

if ($overallTotal > 0)
{
    /* paging */
    echo htmlHelpers::createPagingBlock(WEB_ROOT . "/download_queue." . SITE_CONFIG_PAGE_EXTENSION . "?page=", $overallTotal, $page);
}
?>

<?php

require_once('_footer.php');
?>