<?php

/* setup includes */
require_once('includes/master.inc.php');

/* get params */
if (!$fontId = (int) $_REQUEST['f'])
{
    redirect(WEB_ROOT . "/error.php");
}

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* load font object */
$fontObj = new font($fontId);

/* check we've not hit the max permitted downloads for IP */
if (!$fontObj->checkIpCanDownloadFont())
{
    redirect(WEB_ROOT . "/error.php?e=" . urlencode(t("max_limit_for_ip")));
    die();
}

/* update downloads */
$fontObj->incrementFontDownloads();
$fontObj->addFontDownloadReference();

/* send font file */
$zipFilename = htmlHelpers::formatForUrl($fontObj->fontData['fontName']) . ".zip";
$filePath    = $fontObj->getServerArchivePath();

header("Pragma: public");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: public");
header("Content-Type: application/zip");
$user_agent = strtolower($_SERVER["HTTP_USER_AGENT"]);
if ((is_integer(strpos($user_agent, "msie"))) && (is_integer(strpos($user_agent, "win"))))
{
    header("Content-Disposition: filename=" . $zipFilename . ";");
}
else
{
    header("Content-Disposition: attachment; filename=" . $zipFilename . ";");
}
header("Content-Transfer-Encoding: binary");
header("Content-Length: " . filesize($filePath));
readfile($filePath);
exit();
