<?php
/* setup includes */
require_once('includes/master.inc.php');

/* include mailer class */
require_once(DOC_ROOT . '/includes/phpMailer/class.phpmailer.php');

/* manage any submissions */
if ((int) $_REQUEST['submitme'])
{
    /* get params */
    $emailAddress = trim($_REQUEST['emailAddress']);
    $fullname     = trim($_REQUEST['fullname']);
    $comments     = trim($_REQUEST['comments']);

    /* validation */
    if (strlen($emailAddress) == 0)
    {
        setError(t("please_enter_email_address"));
    }
    elseif (valid_email($emailAddress) == false)
    {
        setError(t("email_address_invalid"));
    }
    elseif (strlen($fullname) == 0)
    {
        setError(t("please_enter_full_name"));
    }
    elseif (strlen($comments) == 0)
    {
        setError(t("please_add_comments"));
    }

    if ((!isErrors()) && (SITE_CONFIG_SHOW_CAPTCHA == 'show'))
    {
        // check captcha
        if (md5($_REQUEST['captchaText']) != $_SESSION['captcha_text'])
        {
            setError(t("failed_captcha", "The captcha text you've entered is incorrect, please try again."));
        }
    }

    if (!isErrors())
    {
        $mail = new PHPMailer(true);
        try
        {
            $mail->AddAddress(SITE_CONFIG_SITE_SUPPORT_EMAIL, "Admin - " . SITE_CONFIG_SITE_NAME);
            $mail->SetFrom($emailAddress, $fullname);
            $mail->Subject = 'Contact form submitted from ' . SITE_CONFIG_SITE_NAME;
            $mail->MsgHTML("Dear Admin,<br/><br/>" . $fullname . " has contacted your from " . SITE_CONFIG_SITE_NAME . ". The details are below/attached:<br/><br/><strong>From Email:</strong> " . $emailAddress . "<br/><strong>From Name:</strong> " . $fullname . "<br/><strong>Comments:</strong> " . str_replace("\n", "<br/>", $comments) . "<br/><strong>IP Address:</strong> " . getUsersIPAddress());
            $mail->Send();
            redirect("contact_thanks." . SITE_CONFIG_PAGE_EXTENSION);
        }
        catch (phpmailerException $e)
        {
            setError($e->getMessage());
        }
        catch (Exception $e)
        {
            setError($e->getMessage());
        }
    }
}

/* setup page */
define("PAGE_NAME", t("contact_page_name"));
define("PAGE_DESCRIPTION", t("contact_meta_description"));
define("PAGE_KEYWORDS", t("contact_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<?php
/* title section */
echo htmlHelpers::createPageTitleHTML("Contact us");
?>

<div class='pageMainContent'>

    <?php
    /* main body */
    echo t("use_form_to_contact_support") . "<br/><br/>";

    /* form */
    echo outputErrors();
    ?>
    <div class="clear"><!-- --></div>

    <div class="submitFontForm">
        <form name="submitFont" id="submitFont" method="POST" action="contact.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">

            <label for="emailAddress"><?php echo t("your_email_address"); ?>:</label>
            <div>
                <input name="emailAddress" id="emailAddress" value="<?php echo safeOutputToScreen($_REQUEST['emailAddress']); ?>" type="text"/>
            </div>

            <label for="fullname"><?php echo t("full_name"); ?>:</label>
            <div>
                <input name="fullname" id="fullname" value="<?php echo safeOutputToScreen($_REQUEST['fullname']); ?>" type="text"/>
            </div>

            <label for="comments"><?php echo t("your_comments"); ?>:</label>
            <div>
                <textarea name="comments" id="comments"><?php echo safeOutputToScreen($_REQUEST['comments']); ?></textarea>
            </div>

            <?php if (SITE_CONFIG_SHOW_CAPTCHA == 'show'): ?>
                <label for='captchaText'><?php echo UCWords(t("captcha", "Confirm Text")); ?>:</label>
                <div style='float: left; padding: 0px;'>
                    <input name='captchaText' id='captchaText' type='text' value='' style='width: 170px;'>
                </div>
                <div style='float: left; padding: 0px;'>
                    <img src='<?php echo WEB_ROOT; ?>/captcha.php' />
                </div>
                <div style="clear: both;"><!-- --></div>
            <?php endif; ?>

            <label for="submitButton">&nbsp;</label>
            <div>
                <input name="submitme" id="submitme" type="hidden" value="1"/>
                <input name="submitButton" class="submitButton" id="submitButton" type="submit" value="<?php echo t("submit_contact"); ?>"/>
            </div>
        </form>
    </div>
</div>
<!-- www.20script.ir -->
<?php
require_once('_footer.php');
?>