<?php
define("PAGE_KEY", "categories");

/* setup includes */
require_once('includes/master.inc.php');

// pickup session
if(isset($_REQUEST['order']))
{
    $_SESSION['filterOrder'] = trim($_REQUEST['order']);
}

// pickup variables
$categoryId = (int) $_REQUEST['c'];
$page       = $_REQUEST['page'];
$order       = isset($_SESSION['filterOrder'])?$_SESSION['filterOrder']:'atoz';
$columnOrder = 'font.fontName ASC';
switch($order)
{
    case 'latest':
        $columnOrder = 'font.dateCreated DESC';
        break;
    case 'atoz':
        $columnOrder = 'font.fontName ASC';
        break;
    case 'ztoa':
        $columnOrder = 'font.fontName DESC';
        break;
    case 'top':
        $columnOrder = 'font.fontRating DESC';
        break;
    case 'downloads':
        $columnOrder = 'font.totalDownloads DESC';
        break;
}

/* for non js users */
if ((int) $categoryId == 0)
{
    $categoryId   = 1;
    define("NO_JS_DISPLAY_CATS", true);
}
/* load up category information */
if (!$categoryName = $db->getRow("SELECT categoryName FROM font_categories WHERE id=" . (int) $categoryId))
{
    redirect(WEB_ROOT . "/error.php");
}

if (!$page)
{
    $page    = 1;
}
$perPage = font::getFontsPerPageSetting();

$sQLClause = "WHERE font_categories_join.categoryId = " . (int) $categoryId;
$sQLClause .= " AND status = 'active' ";

/* total items */
$overallTotal = $db->getValue("SELECT COUNT(font.id) AS total FROM font LEFT JOIN font_categories_join ON font.id = font_categories_join.fontId " . $sQLClause);
$pageTitle    = $categoryName['categoryName'] . " " . t("fonts");

/* setup page */
define("PAGE_NAME", $pageTitle);
define("PAGE_DESCRIPTION", $pageTitle . ". " . t("category_meta_description"));
define("PAGE_KEYWORDS", strtolower($categoryName['categoryName']) . ", " . t("category_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<div class="sortFilterForm">
    <form method="GET" action="<?php echo WEB_ROOT . "/c/" . $categoryId . "/" . htmlHelpers::formatForUrl($categoryName['categoryName']) . "/"; ?>">
        <label fo="order"><?php echo t("sort_by", "Sort By"); ?>:</label>
        <select name="order" onChange="this.form.submit();">
            <option value="latest" <?php echo ($order == 'latest')?'SELECTED':''; ?>><?php echo t("newest", "Newest"); ?></option>
            <option value="atoz" <?php echo ($order == 'atoz')?'SELECTED':''; ?>><?php echo t("by_font_name_atoz", "By Font Name (a to z)"); ?></option>
            <option value="ztoa" <?php echo ($order == 'ztoa')?'SELECTED':''; ?>><?php echo t("by_font_name_ztoa", "By Font Name (z to a)"); ?></option>
            <option value="top" <?php echo ($order == 'top')?'SELECTED':''; ?>><?php echo t("by_top_rated", "Top Rated"); ?></option>
            <option value="downloads" <?php echo ($order == 'downloads')?'SELECTED':''; ?>><?php echo t("most_downloads", "Most Downloads"); ?></option>
        </select>
    </form>
</div>

<?php

/* title section */
echo htmlHelpers::createPageTitleHTML($pageTitle);

echo "<div class='pageMainContent'>";

/* main body */
$limitedRS = $db->getRows("SELECT font.* FROM font LEFT JOIN font_categories_join ON font.id = font_categories_join.fontId " . $sQLClause . " ORDER BY ".$columnOrder." LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
$tracker   = 1;
$totalRows = COUNT($limitedRS);
foreach ($limitedRS AS $fontRow)
{
    echo fontPreviewBlock::createHTMLBlock($fontRow);

    if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
    {
        if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
        {
            echo '<div class="inlinePageAds">';
            echo SITE_CONFIG_ADVERT_INLINE_LISTING;
            echo '</div>';
        }

        $tracker++;
    }
}

echo "</div>";

/* paging */
echo htmlHelpers::createPagingBlock(WEB_ROOT . "/c/" . $categoryId . "/" . htmlHelpers::formatForUrl($categoryName['categoryName']) . "/", $overallTotal, $page);
?>

<?php

require_once('_footer.php');
?>