<?php
define("PAGE_KEY", "browse");

/* setup includes */
require_once('includes/master.inc.php');

// pickup session
if(isset($_REQUEST['order']))
{
    $_SESSION['filterOrder'] = trim($_REQUEST['order']);
}

$letter = $_REQUEST['l'];
$page   = $_REQUEST['page'];
$order       = isset($_SESSION['filterOrder'])?$_SESSION['filterOrder']:'atoz';
$columnOrder = 'font.fontName ASC';
switch($order)
{
    case 'latest':
        $columnOrder = 'font.dateCreated DESC';
        break;
    case 'atoz':
        $columnOrder = 'font.fontName ASC';
        break;
    case 'ztoa':
        $columnOrder = 'font.fontName DESC';
        break;
    case 'top':
        $columnOrder = 'font.fontRating DESC';
        break;
    case 'downloads':
        $columnOrder = 'font.totalDownloads DESC';
        break;
}

/* for non js users */
if (str_replace("/", "", $letter) == "-")
{
    $letter = "a";
    define("NO_JS_DISPLAY_BROWSE", true);
}

$validArr = explode(",", "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,num");
if ((!$letter) || (!in_array($letter, $validArr)))
{
    $letter = "a";
}
if (!$page)
{
    $page    = 1;
}
$perPage = font::getFontsPerPageSetting();

/* setup $sQLClause */
$sQLClause = "WHERE ";
if ($letter == "num")
{
    $sQLClause .= "1 != 1";
    $clauseValueArr = explode(",", "1,2,3,4,5,6,7,8,9,0,!,$,&,^,*(,),-,+,=,[,],@,~,.,/,?");
    foreach ($clauseValueArr AS $clauseValue)
    {
        $sQLClause .= " || (fontName) LIKE '" . $db->escape($clauseValue) . "%'";
    }
}
else
{
    $sQLClause .= "UCASE(fontName) LIKE '" . $db->escape($letter) . "%'";
}
$sQLClause .= " AND status = 'active' ";

/* total items */
$overallTotal = $db->getValue("SELECT COUNT(id) AS total FROM font " . $sQLClause);

$pageTitle = t("browsing_fonts_starting_with") . " " . strtoupper($letter);
if ($letter == "num")
{
    $pageTitle = t("browsing_fonts_starting_non_alpha");
}

/* setup page */
define("PAGE_NAME", $pageTitle);
define("PAGE_DESCRIPTION", t("browse_meta_description"));
define("PAGE_KEYWORDS", t("browse_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');
?>

<div class="sortFilterForm">
    <form method="GET" action="<?php echo WEB_ROOT . "/a-z/" . $letter . "/1/"; ?>">
        <label fo="order"><?php echo t("sort_by", "Sort By"); ?>:</label>
        <select name="order" onChange="this.form.submit();">
            <option value="latest" <?php echo ($order == 'latest')?'SELECTED':''; ?>><?php echo t("newest", "Newest"); ?></option>
            <option value="atoz" <?php echo ($order == 'atoz')?'SELECTED':''; ?>><?php echo t("by_font_name_atoz", "By Font Name (a to z)"); ?></option>
            <option value="ztoa" <?php echo ($order == 'ztoa')?'SELECTED':''; ?>><?php echo t("by_font_name_ztoa", "By Font Name (z to a)"); ?></option>
            <option value="top" <?php echo ($order == 'top')?'SELECTED':''; ?>><?php echo t("by_top_rated", "Top Rated"); ?></option>
            <option value="downloads" <?php echo ($order == 'downloads')?'SELECTED':''; ?>><?php echo t("most_downloads", "Most Downloads"); ?></option>
        </select>
    </form>
</div>

<?php

/* title section */
echo htmlHelpers::createPageTitleHTML($pageTitle);

echo "<div class='pageMainContent'>";

/* main body */
$limitedRS = $db->getRows("SELECT * FROM font " . $sQLClause . " ORDER BY ".$columnOrder." LIMIT " . ($perPage * ($page - 1)) . ", " . $perPage);
$tracker   = 1;
$totalRows = COUNT($limitedRS);
foreach ($limitedRS AS $fontRow)
{
    echo fontPreviewBlock::createHTMLBlock($fontRow);

    if ((strlen(trim(SITE_CONFIG_ADVERT_INLINE_LISTING))) && ((int) SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD > 0))
    {
        if (($tracker % SITE_CONFIG_ADVERT_INLINE_LISTING_PERIOD == 0) && ($tracker != $totalRows))
        {
            echo '<div class="inlinePageAds">';
            echo SITE_CONFIG_ADVERT_INLINE_LISTING;
            echo '</div>';
        }

        $tracker++;
    }
}

echo "</div>";

/* paging */
echo htmlHelpers::createPagingBlock(WEB_ROOT . "/a-z/" . $letter . "/", $overallTotal, $page);
?>

<?php

require_once('_footer.php');
?>