<?php
define('ADMIN_PAGE_TITLE', 'Dashboard');
include_once('_local_auth.inc.php');
include_once('_header.inc.php');

// load stats
$totalActiveFonts     = (int) $db->getValue("SELECT COUNT(id) AS total FROM font WHERE status = 'active'");
$totalDownloads       = (int) $db->getValue("SELECT SUM(totalDownloads) AS total FROM font");
$totalPendingFonts    = (int) $db->getValue("SELECT COUNT(id) AS total FROM font WHERE status = 'pending'");
$totalComments        = (int) $db->getValue("SELECT COUNT(id) AS total FROM font_comment WHERE status='active'");
$totalPendingComments = (int) $db->getValue("SELECT COUNT(id) AS total FROM font_comment WHERE status='pending'");
$newFonts30Days       = (int) $db->getValue("SELECT COUNT(id) AS total FROM font WHERE dateCreated BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()");
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon largeDashboardIcon"></div>
        <div class="widget clearfix">
            <h2><?php echo adminFunctions::t('quick_overview', 'Quick Overview'); ?></h2>
            <div class="widget_inside">
                <h3>Current Statistics</h3>
                <div class="report">
                    <a href="font_manage.php">
                        <div class="button up">
                            <span class="value"><?php echo $totalActiveFonts; ?></span>
                            <span class="attr">Fonts</span>
                        </div>
                    </a>

                    <a href="font_manage.php?filterByStatus=pending">
                        <div class="button up">
                            <span class="value"><?php echo $totalPendingFonts; ?></span>
                            <span class="attr">Pending Fonts</span>
                        </div>
                    </a>

                    <a href="font_manage.php">
                        <div class="button up">
                            <span class="value"><?php echo $totalDownloads; ?></span>
                            <span class="attr">Total Font Downloads</span>
                        </div>
                    </a>

                    <a href="font_manage.php">
                        <div class="button up">
                            <span class="value"><?php echo $newFonts30Days; ?></span>
                            <span class="attr">30 Day New Fonts</span>
                        </div>
                    </a>

                    <a href="comment_manage.php">
                        <div class="button up">
                            <span class="value"><?php echo $totalComments; ?></span>
                            <span class="attr">Total Comments</span>
                        </div>
                    </a>

                    <a href="comment_manage.php?filterByStatus=<?php echo urlencode('pending'); ?>">
                        <div class="button up">
                            <span class="value"><?php echo $totalPendingComments; ?></span>
                            <span class="attr">Pending Comments</span>
                        </div>
                    </a>


                </div>
            </div>
        </div>
    </div>
</div>

<?php
// last 14 days downloads
$tracker              = 14;
$last14Days           = array();
while ($tracker >= 0)
{
    $date              = date("Y-m-d", strtotime("-" . $tracker . " day"));
    $last14Days[$date] = 0;
    $tracker--;
}

$tracker = 1;
$data    = array();
$label = array();
foreach ($last14Days AS $k => $total)
{
    $totalFonts = $db->getValue("SELECT COUNT(id) AS total FROM stats WHERE MID(dt, 1, 10) = '" . $k . "'");
    $data[]     = '[' . $tracker . ',' . (int) $totalFonts . ']';
    $label[]    = '[' . $tracker . ',\'' . date('jS', strtotime($k)) . '\']';
    $tracker++;
}
?>

<div class="row clearfix">
    <div class="col_8">
        <div class="widget clearfix">
            <h2><?php echo adminFunctions::t("dashboard_graph_last_14_days_title", "Total Downloads (last 14 days)"); ?></h2>
            <div class="widget_inside">
                <div id="14_day_chart" style="width:100%; height:300px;" class="centered"></div>
                <script type="text/javascript">
                    $(function () {
                        var css_id = "#14_day_chart";
                        var data = [
                            {label: '<?php echo UCWords(adminFunctions::t("downloads", "downloads")); ?>', data: [<?php echo implode(", ", $data); ?>]}
                        ];
                        var options = {
                            series: {stack: 0,
                                lines: {show: false, steps: false },
                                grid: {backgroundColor: { colors: ["#fff", "#eee"] } },
                                bars: {show: true, barWidth: 0.9, align: 'center' } },
                            xaxis: {ticks: [<?php echo implode(", ", $label); ?>]},
                            colors: [ "#55A9D3" ]
                        };

                        $.plot($(css_id), data, options);
                    });
                </script>
            </div>
        </div>
    </div>

    <?php
    // pie chart of the status of items
    $data       = array();
    $dataForPie = $db->getRows("SELECT COUNT(font.id) AS total, font.status FROM font GROUP BY font.status");
    foreach ($dataForPie AS $dataRow)
    {
        $data[]       = '{ label: "' . UCWords(adminFunctions::t($dataRow['status'], $dataRow['status'])) . '",  data: ' . (int) $dataRow['total'] . '}';
    }
    ?>
    <div class="col_4 last">
        <div class="widget">
            <h2><?php echo adminFunctions::t('font_status', 'Font Status'); ?></h2>
            <div class="widget_inside">
                <div id="font_status_chart" style="width:100%; height: 300px" class="centered"></div>
                <div id="font_status_chart_hover" class="pieHoverText"></div>
                <script type="text/javascript">
                    $(function () {
                        // data
                        var data = [
<?php echo implode(', ', $data); ?>
        ];

        // INTERACTIVE
        $.plot($("#font_status_chart"), data,
        {
            series: {
                pie: {
                    show: true
                }
            },
            grid: {
                hoverable: true,
                clickable: true
            },
            legend: {
                show: true
            }
        });
        $("#font_status_chart").bind("plothover", fontStatusChartHover);

    });

    function fontStatusChartHover(event, pos, obj)
    {
        if (!obj)
            return;
        percent = parseFloat(obj.series.percent).toFixed(2);
        $("#font_status_chart_hover").html('<span style="font-weight: bold; color: '+obj.series.color+'">'+obj.series.label+' ('+percent+'%)</span>');
    }
                </script>
            </div>
        </div>
    </div>
</div>


<?php
// last 12 months downloads
$tracker      = 12;
$last12Months = array();
while ($tracker >= 0)
{
    $date                = date("Y-m", strtotime("-" . $tracker . " month"));
    $last12Months[$date] = 0;
    $tracker--;
}

$tracker = 1;
$data    = array();
$label = array();
foreach ($last12Months AS $k => $total)
{
    $totalFonts = $db->getValue("SELECT COUNT(id) AS total FROM stats WHERE MID(dt, 1, 7) = '" . $k . "'");
    $data[]     = '[' . $tracker . ',' . (int) $totalFonts . ']';
    $label[]    = '[' . $tracker . ',\'' . date('M y', strtotime($k)) . '\']';
    $tracker++;
}
?>

<div class="row clearfix">
    <div class="col_8">
        <div class="widget clearfix">
            <h2><?php echo adminFunctions::t("dashboard_graph_last_12_months_title", "Total Downloads (last 12 months)"); ?></h2>
            <div class="widget_inside">
                <div id="12_months_chart" style="width:100%; height:300px;" class="centered"></div>
                <script type="text/javascript">
                    $(function () {
                        var css_id = "#12_months_chart";
                        var data = [
                            {label: '<?php echo UCWords(adminFunctions::t("fonts", "fonts")); ?>', data: [<?php echo implode(", ", $data); ?>]}
                        ];
                        var options = {
                            series: {stack: 0,
                                lines: {show: false, steps: false },
                                grid: {backgroundColor: { colors: ["#fff", "#eee"] } },
                                bars: {show: true, barWidth: 0.9, align: 'center' } },
                            xaxis: {ticks: [<?php echo implode(", ", $label); ?>]},
                            colors: [ "#55A9D3" ]
                        };

                        $.plot($(css_id), data, options);
                    });
                </script>
            </div>
        </div>
    </div>

    <?php
// pie chart of categories
    $data       = array();
    $dataForPie = $db->getRows("SELECT COUNT(font.id) AS total, font_categories.categoryName FROM font LEFT JOIN font_categories_join ON font.id = font_categories_join.fontId LEFT JOIN font_categories ON font_categories_join.categoryId = font_categories.id WHERE font.status='active' GROUP BY font_categories.categoryName ORDER BY COUNT(font.id) DESC");
    $counter    = 1;
    $otherTotal = 0;
    foreach ($dataForPie AS $dataRow)
    {
        if (($counter > 16) || strlen($dataRow['categoryName']) == 0)
        {
            $otherTotal = $otherTotal + $dataRow['total'];
        }
        else
        {
            $data[] = '{ label: "' . UCWords(strtolower($dataRow['categoryName'])) . '",  data: ' . (int) $dataRow['total'] . '}';
        }
        $counter++;
    }
    if ($otherTotal > 0)
    {
        $data[]     = '{ label: "' . strtolower(adminFunctions::t('other', 'other')) . '",  data: ' . (int) $otherTotal . '}';
    }
    ?>
    <div class="col_4 last">
        <div class="widget">
            <h2><?php echo adminFunctions::t('category', 'Category'); ?></h2>
            <div class="widget_inside">
                <div id="font_category_chart" style="width:100%; height: 300px" class="centered"></div>
                <div id="font_category_chart_hover" class="pieHoverText"></div>
                <script type="text/javascript">
                    $(function () {
                        // data
                        var data = [
<?php echo implode(', ', $data); ?>
        ];

        // INTERACTIVE
        $.plot($("#font_category_chart"), data,
        {
            series: {
                pie: {
                    show: true
                }
            },
            grid: {
                hoverable: true,
                clickable: true
            },
            legend: {
                show: false
            }
        });
        $("#font_category_chart").bind("plothover", fontCategoryChartHover);

    });

    function fontCategoryChartHover(event, pos, obj)
    {
        if (!obj)
            return;
        percent = parseFloat(obj.series.percent).toFixed(2);
        $("#font_category_chart_hover").html('<span style="font-weight: bold; color: '+obj.series.color+'">'+obj.series.label+' ('+percent+'%)</span>');
    }
                </script>
            </div>
        </div>
    </div>
</div>


<?php
// last 12 months new fonts
$tracker      = 12;
$last12Months = array();
while ($tracker >= 0)
{
    $date                = date("Y-m", strtotime("-" . $tracker . " month"));
    $last12Months[$date] = 0;
    $tracker--;
}

$tracker = 1;
$data    = array();
$label = array();
foreach ($last12Months AS $k => $total)
{
    $totalFonts = $db->getValue("SELECT COUNT(id) AS total FROM font WHERE MID(dateCreated, 1, 7) = '" . $k . "'");
    $data[]     = '[' . $tracker . ',' . (int) $totalFonts . ']';
    $label[]    = '[' . $tracker . ',\'' . date('M y', strtotime($k)) . '\']';
    $tracker++;
}
?>

<div class="row clearfix">
    <div class="col_8">
        <div class="widget clearfix">
            <h2><?php echo adminFunctions::t("dashboard_graph_last_12_months_title_new_fonts", "New Fonts (last 12 months)"); ?></h2>
            <div class="widget_inside">
                <div id="12_new_fonts_months_chart" style="width:100%; height:300px;" class="centered"></div>
                <script type="text/javascript">
                    $(function () {
                        var css_id = "#12_new_fonts_months_chart";
                        var data = [
                            {label: '<?php echo UCWords(adminFunctions::t("fonts", "fonts")); ?>', data: [<?php echo implode(", ", $data); ?>]}
                        ];
                        var options = {
                            series: {stack: 0,
                                lines: {show: false, steps: false },
                                grid: {backgroundColor: { colors: ["#fff", "#eee"] } },
                                bars: {show: true, barWidth: 0.9, align: 'center' } },
                            xaxis: {ticks: [<?php echo implode(", ", $label); ?>]},
                            colors: [ "#55A9D3" ]
                        };

                        $.plot($(css_id), data, options);
                    });
                </script>
            </div>
        </div>
    </div>
</div>

<?php
include_once('_footer.inc.php');
?>