<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Manage Fonts');
define('ADMIN_SELECTED_PAGE', 'font_manage');

if (isset($_REQUEST['filterByStatus']))
{
    define('ADMIN_SELECTED_SUB_PAGE', 'font_manage_pending_approval');
}
else
{
    define('ADMIN_SELECTED_SUB_PAGE', 'font_manage');
}

// includes and security
include_once('_local_auth.inc.php');

// fix for utf conversion
fixDatabaseCharacterEncoding();

// page header
include_once('_header.inc.php');

// error/success messages
if (isset($_REQUEST['sa']))
{
    adminFunctions::setSuccess('Font successfully added.');
}
elseif (isset($_REQUEST['se']))
{
    adminFunctions::setSuccess('Font successfully updated.');
}
elseif (isset($_REQUEST['error']))
{
    adminFunctions::setError(urldecode($_REQUEST['error']));
}

// load categories
$categoryDetails = $db->getRows("SELECT font_categories.id, font_categories.categoryName, COUNT(font_categories_join.fontId) AS totalFonts FROM font_categories LEFT JOIN font_categories_join ON font_categories.id = font_categories_join.categoryId GROUP BY font_categories.categoryName ORDER BY font_categories.categoryName");

// load all font status
$statusDetails = array('active', 'disabled', 'pending');

// defaults
$filterText = '';
if (isset($_REQUEST['filterText']))
{
    $filterText = trim($_REQUEST['filterText']);
}

$filterByStatus = 'active';
if (isset($_REQUEST['filterByStatus']))
{
    $filterByStatus = $_REQUEST['filterByStatus'];
}

$filterByCategoryId = '';
if (isset($_REQUEST['filterByCategoryId']))
{
    $filterByCategoryId = (int)$_REQUEST['filterByCategoryId'];
}

$filterByUser = '';
if (isset($_REQUEST['filterByUser']))
{
    $filterByUser = (int)$_REQUEST['filterByUser'];
}

?>

<script>
    oTable = null;
    gFontId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/file_manage.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 1, "asc" ]],
            "aoColumns" : [   
                { bSortable: false, sWidth: '3%', sName: 'font_icon', sClass: "center adminResponsiveHide" },
                { sName: 'font_name', sWidth: '18%' },
                { sName: 'font_designer', sClass: "center adminResponsiveHide" },
                { sName: 'date_created', sWidth: '12%', sClass: "center adminResponsiveHide" },
                { sName: 'font_rating', sWidth: '10%', sClass: "center adminResponsiveHide" },
                { sName: 'total_downloads', sWidth: '10%', sClass: "center adminResponsiveHide" },
                { sName: 'status', sWidth: '10%', sClass: "center" },
                { bSortable: false, sWidth: '20%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                aoData.push( { "name": "filterByStatus", "value": $('#filterByStatus').val() } );
                aoData.push( { "name": "filterByCategoryId", "value": $('#filterByCategoryId').val() } );
                <?php if(strlen($filterByUser)): ?>
                    aoData.push( { "name": "filterByUser", "value": <?php echo $filterByUser; ?> } );
                <?php endif; ?>
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/font_manage.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
        
        // dialog box
        $( "#confirmDelete" ).dialog({
            modal: true,
            autoOpen: false,
            width: getDefaultDialogWidth(),
            buttons: {
                "Delete Font": function() {
                    removeFont();
                    $("#confirmDelete").dialog("close");
                },
                "Cancel": function() {
                    $("#confirmDelete").dialog("close");
                }
            },
            open: function() {
                resetOverlays();
            }
        });
    });

    function reloadTable()
    {
        oTable.fnDraw(false);
    }
    
    function confirmRemoveFont(fontId)
    {
        $('#confirmDelete').dialog('open');
        gFontId = fontId;
    }
    
    function removeFont()
    {
        $.ajax({
            type: "POST",
            url: "ajax/update_font_state.ajax.php",
            data: { fontId: gFontId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable(); 
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
    
    function approveFont(fontId)
    {
        $.ajax({
            type: "POST",
            url: "ajax/update_font_state.ajax.php",
            data: { fontId: fontId, approve: 1 },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable(); 
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
</script>

<div class="row clearfix">
    <div class="sectionLargeIcon largeFileIcon"></div>
    <div class="widget clearfix">
        <h2>Font List</h2>
        <div class="widget_inside">
            <?php echo adminFunctions::compileNotifications(); ?>
            <div class="col_12">
                <table id='fileTable' class='dataTable'>
                    <thead>
                        <tr>
                            <th></th>
                            <th class="align-left"><?php echo adminFunctions::t('font_name', 'Font Name'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('font_designer', 'Font Designer'); ?></th>
                            <th><?php echo adminFunctions::t('date_created', 'Date Created'); ?></th>
                            <th><?php echo adminFunctions::t('font_rating', 'Font Rating'); ?></th>
                            <th><?php echo adminFunctions::t('downloads', 'Downloads'); ?></th>
                            <th><?php echo adminFunctions::t('status', 'Status'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <form action="font_add.php" method="GET">
                <input type="submit" value="Add Font" class="button blue"/>
            </form>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        Filter Results:
        <input name="filterText" id="filterText" type="text" value="<?php echo adminFunctions::makeSafe($filterText); ?>" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
    <label class="adminResponsiveHide" style="padding-left: 6px;">
        By Status:
        <select name="filterByStatus" id="filterByStatus" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($statusDetails))
            {
                foreach ($statusDetails AS $statusLabel)
                {
                    echo '<option value="' . $statusLabel . '"';
                    if ($filterByStatus == $statusLabel)
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords($statusLabel) . '</option>';
                }
            }
            ?>
        </select>
    </label>
    <label class="adminResponsiveHide" style="padding-left: 6px;">
        By Category:
        <select name="filterByCategoryId" id="filterByCategoryId" onChange="reloadTable(); return false;" style="width: 200px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($categoryDetails))
            {
                foreach ($categoryDetails AS $categoryDetail)
                {
                    echo '<option value="' . $categoryDetail['id'] . '"';
                    if ($filterByCategoryId == $categoryDetail['id'])
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords($categoryDetail['categoryName']) . ' ('.$categoryDetail['totalFonts'].')</option>';
                }
            }
            ?>
        </select>
    </label>
</div>

<div id="confirmDelete" title="Confirm Action">
    <p>Are you sure you want to remove this font? All files, comments, statistics etc will be permanently deleted.</p>
</div>

<?php
include_once('_footer.inc.php');
?>