<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'font_manage');

// includes and security
include_once('_local_auth.inc.php');

// load user details
$fontId = (int) $_REQUEST['id'];
$font   = $db->getRow("SELECT * FROM font WHERE id = " . (int) $fontId . " LIMIT 1");
if (!$font)
{
    adminFunctions::redirect('font_manage.php?error=' . urlencode('There was a problem loading the font details.'));
}
define('ADMIN_PAGE_TITLE', 'Edit Font: \'' . $font['fontName'] . '\'');

// load font object for preview
$fontObj      = new font($font['id'], $font);

// load existing categories
$font_categories = array();
$fontCategories = $db->getRows("SELECT categoryId FROM font_categories_join WHERE fontId = " . (int) $fontId);
if ($fontCategories)
{
    foreach ($fontCategories AS $fontCategory)
    {
        $font_categories[] = $fontCategory['categoryId'];
    }
}

// prepare variables
$font_name        = $font['fontName'];
$font_designer    = $font['fontDesigner'];
$clear_cache      = '';
$font_license     = $font['licenseId'];
$url_website      = $font['urlWebsite'];
$url_profile      = $font['urlProfile'];
$url_blog         = $font['urlBlog'];
$preview_override = $font['previewOverride'];

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $font_name        = trim($_REQUEST['font_name']);
    $font_designer    = trim($_REQUEST['font_designer']);
    $font_categories  = $_REQUEST['font_categories'];
    $font_file        = $_FILES['font_file'];
    $clear_cache      = isset($_FILES['clear_cache']) ? true : false;
    $font_license     = (int) $_REQUEST['font_license'];
    $url_website      = strtolower(trim($_REQUEST['url_website']));
    $url_profile      = strtolower(trim($_REQUEST['url_profile']));
    $url_blog         = strtolower(trim($_REQUEST['url_blog']));
    $preview_override = trim($_REQUEST['preview_override']);

    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    elseif (strlen($font_name) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_enter_font_name"));
    }
    elseif (strlen($font_designer) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_enter_the_designer"));
    }
    elseif (COUNT($font_categories) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_select_category"));
    }

    // add the font
    if (adminFunctions::isErrors() == false)
    {
        // tidy
        if (substr($url_website, 0, 3) == 'www')
        {
            $url_website = 'http://' . $url_website;
        }
        if (substr($url_profile, 0, 3) == 'www')
        {
            $url_profile = 'http://' . $url_profile;
        }
        if (substr($url_blog, 0, 3) == 'www')
        {
            $url_blog = 'http://' . $url_blog;
        }

        // update the font
        $dbUpdate = new DBObject("font", array("fontName", "fontDesigner", "licenseId", "urlWebsite", "urlProfile", "urlBlog", "previewOverride"), 'id');
        $dbUpdate->fontName = $font_name;
        $dbUpdate->fontDesigner = $font_designer;
        $dbUpdate->licenseId = $font_license;
        $dbUpdate->urlWebsite = $url_website;
        $dbUpdate->urlProfile = $url_profile;
        $dbUpdate->urlBlog = $url_blog;
        $dbUpdate->previewOverride = $preview_override;
        $dbUpdate->id = $fontId;
        $dbUpdate->update();

        // delete categories
        $db->query("DELETE FROM font_categories_join WHERE fontId = :fontId", array('fontId' => (int) $fontId));

        // update cats
        foreach ($font_categories AS $font_category)
        {
            $dbInsertCat = new DBObject("font_categories_join", array("fontId", "categoryId"));
            $dbInsertCat->fontId = $fontId;
            $dbInsertCat->categoryId = $font_category;
            $dbInsertCat->insert();
        }

        // fonts library
        require_once(DOC_ROOT . '/includes/class.font.php');

        // new upload, make sure we clear the cache
        if (strlen($font_file['name']))
        {
            $clear_cache = true;
        }
        
        if($preview_override != $font['previewOverride'])
        {
            $clear_cache = true;
        }

        // clear cache
        if ($clear_cache == true)
        {
            // clear cache
            if (is_dir(FONTS_PREVIEW_CACHE_FOLDER . (int) $fontId . '/'))
            {
                @htmlHelpers::deleteDir(FONTS_PREVIEW_CACHE_FOLDER . (int) $fontId . '/');
            }
        }

        // replace font file
        if (strlen($font_file['name']))
        {
            // clear archive files
            if (is_dir(FONTS_UNPACKED_ARCHIVE . (int) $fontId . '/'))
            {
                @htmlHelpers::deleteDir(FONTS_UNPACKED_ARCHIVE . (int) $fontId . '/');
            }

            // remove font files
            $archive = FONTS_ARCHIVE_FOLDER . (int) $fontId . ".zip";
            if (file_exists($archive))
            {
                @unlink($archive);
            }

            /* move uploaded font archive */
            $newZipFilePath = FONTS_ARCHIVE_FOLDER . $fontId . ".zip";
            rename($font_file['tmp_name'], $newZipFilePath);
        }

        adminFunctions::redirect('font_manage.php?se=1');
    }
}

// page header
include_once('_header.inc.php');
?>

<script>
    $(function() {
        // formvalidator
        $("#fontForm").validationEngine();
    });
</script>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon largeUserAddIcon"></div>
        <div class="widget clearfix">
            <h2>Font Details</h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="font_edit.php" name="fontForm" id="fontForm" enctype="multipart/form-data">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Font Details</h3>
                            <p>Enter the details of the font.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Font Name:</label>
                                    <div class="input"><input id="font_name" name="font_name" type="text" class="xxlarge validate[required]" value="<?php echo adminFunctions::makeSafe($font_name); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label>License:</label>
                                    <div class="input">
                                        <select name="font_license" id="font_license" class="xlarge validate[required]">
                                            <?php
                                            $licenses = $db->getRows("SELECT id, label FROM font_license ORDER BY label");
                                            foreach ($licenses AS $license)
                                            {
                                                echo "<option value=\"" . $license['id'] . "\"";
                                                if ($license['id'] == $font_license)
                                                {
                                                    echo " SELECTED";
                                                }
                                                echo ">" . ($license['label']) . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label>Categories:<br/><br/>(hold ctrl to select more than 1)</label>
                                    <div class="input">
                                        <select name="font_categories[]" id="font_categories" multiple size="10" class="xlarge validate[required]">
                                            <?php
                                            $cats = $db->getRows("SELECT id, categoryName FROM font_categories ORDER BY categoryName");
                                            foreach ($cats AS $cat)
                                            {
                                                echo "<option value=\"" . $cat['id'] . "\"";
                                                if (in_array($cat['id'], $font_categories))
                                                {
                                                    echo " SELECTED";
                                                }
                                                echo ">" . ($cat['categoryName']) . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label for="font_file">Font Zip File: (replace existing)</label>
                                    <div class="input">
                                        <input name="font_file" id="font_file" type="file" class="xlarge"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					
					<div class="clearfix col_12">
						<div class="col_4">&nbsp;</div>
						<div class="col_8 last">
							<div class='fontPreviewImageWrapperDefault' style='background: url("<?php echo $fontObj->getPreviewUrl(); ?>") no-repeat left top; height: 90px;'></div>
						</div>
					</div>

                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Font Designer</h3>
                            <p>Designer name, website url, profile url, blog url.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label for="font_designer">Font Designer:</label>
                                    <div class="input"><input id="font_designer" name="font_designer" type="text" class="xxlarge validate[required]" value="<?php echo adminFunctions::makeSafe($font_designer); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label for="url_website">Website Url:</label>
                                    <div class="input"><input id="url_website" name="url_website" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_website); ?>"/></div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label for="url_profile">Profile Url:</label>
                                    <div class="input"><input id="url_profile" name="url_profile" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_profile); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label for="url_blog">Blog Url:</label>
                                    <div class="input"><input id="url_blog" name="url_blog" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_blog); ?>"/></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Font Previews</h3>
                            <p>Clear any cached font preview images.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label for="clear_cache">Clear Preview Cache:</label>
                                    <div class="input" style="padding-top: 2px;">
                                        <input name="clear_cache" id="clear_cache" type="checkbox" value="1"/>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label for="preview_override">Force Preview Text:</label>
                                    <div class="input"><input id="preview_override" name="preview_override" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($preview_override); ?>"/></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Update Font" class="button blue">
                                    <input type="reset" value="Reset" class="button grey">
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $fontId; ?>"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<?php
include_once('_footer.inc.php');
?>