<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Add New Font');
define('ADMIN_SELECTED_PAGE', 'font_manage');
define('ADMIN_SELECTED_SUB_PAGE', 'add_font');

// includes and security
include_once('_local_auth.inc.php');

// prepare variables
$font_name       = '';
$font_designer   = '';
$font_categories = array();
$font_license  = 1;
$url_website   = '';
$url_profile   = '';
$url_blog      = '';

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $font_name       = trim($_REQUEST['font_name']);
    $font_designer   = trim($_REQUEST['font_designer']);
    $font_categories = $_REQUEST['font_categories'];
    $font_file       = $_FILES['font_file'];
    $font_license    = (int) $_REQUEST['font_license'];
    $url_website     = strtolower(trim($_REQUEST['url_website']));
    $url_profile     = strtolower(trim($_REQUEST['url_profile']));
    $url_blog        = strtolower(trim($_REQUEST['url_blog']));

    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    elseif (strlen($font_name) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_enter_font_name"));
    }
    elseif (strlen($font_designer) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_enter_the_designer"));
    }
    elseif (COUNT($font_categories) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_select_category"));
    }
    elseif (strlen($font_file['name']) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_attach_zip_archive"));
    }
    elseif (font::getFileExtension($font_file['name']) != "zip")
    {
        adminFunctions::setError(adminFunctions::t("font_archive_not_zip"));
    }

    // add the font
    if (adminFunctions::isErrors() == false)
    {
        // tidy
        if(substr($url_website, 0, 3) == 'www')
        {
            $url_website = 'http://'.$url_website;
        }
        if(substr($url_profile, 0, 3) == 'www')
        {
            $url_profile = 'http://'.$url_profile;
        }
        if(substr($url_blog, 0, 3) == 'www')
        {
            $url_blog = 'http://'.$url_blog;
        }
        
        /* add the font to the system */
        $dbInsert = new DBObject("font", array("fontName", "fontDesigner", "dateCreated", "status", "submissionIpAddress", "submittedUserId", "licenseId", "urlWebsite", "urlProfile", "urlBlog"));
        $dbInsert->fontName = $font_name;
        $dbInsert->fontDesigner = $font_designer;
        $dbInsert->dateCreated = sqlDateTime();
        $dbInsert->submissionIpAddress = getUsersIPAddress();
        $dbInsert->submittedUserId = $Auth->id;
        $dbInsert->status = "active";
        $dbInsert->licenseId = $font_license;
        $dbInsert->urlWebsite = $url_website;
        $dbInsert->urlProfile = $url_profile;
        $dbInsert->urlBlog = $url_blog;
        $dbInsert->insert();
        if (!$dbInsert->id)
        {
            adminFunctions::setError(adminFunctions::t("error_problem_record"));
        }
        else
        {
            $newZipFilename = $dbInsert->id;

            /* insert categories */
            foreach ($font_categories AS $font_category)
            {
                $dbInsertCat = new DBObject("font_categories_join", array("fontId", "categoryId"));
                $dbInsertCat->fontId = $newZipFilename;
                $dbInsertCat->categoryId = $font_category;
                $dbInsertCat->insert();
            }

            /* move uploaded font archive */
            $newZipFilePath = FONTS_ARCHIVE_FOLDER . $newZipFilename . ".zip";
            rename($font_file['tmp_name'], $newZipFilePath);

            adminFunctions::redirect('font_manage.php?sa=1');
        }
    }
}

// page header
include_once('_header.inc.php');
?>

<script>
    $(function() {
        // formvalidator
        $("#fontForm").validationEngine();
    });
</script>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon largeUserAddIcon"></div>
        <div class="widget clearfix">
            <h2>User Details</h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="font_add.php" name="fontForm" id="fontForm" enctype="multipart/form-data">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Font Details</h3>
                            <p>Enter the details of the font.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Font Name:</label>
                                    <div class="input"><input id="font_name" name="font_name" type="text" class="xxlarge validate[required]" value="<?php echo adminFunctions::makeSafe($font_name); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label>License:</label>
                                    <div class="input">
                                        <select name="font_license" id="font_license" class="xlarge validate[required]">
                                            <?php
                                            $licenses = $db->getRows("SELECT id, label FROM font_license ORDER BY label");
                                            foreach ($licenses AS $license)
                                            {
                                                echo "<option value=\"" . $license['id'] . "\"";
                                                if ($license['id'] == $font_license)
                                                {
                                                    echo " SELECTED";
                                                }
                                                echo ">" . ($license['label']) . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label>Categories:<br/><br/>(hold ctrl to select more than 1)</label>
                                    <div class="input">
                                        <select name="font_categories[]" id="font_categories" multiple size="10" class="xlarge validate[required]">
                                            <?php
                                            $cats = $db->getRows("SELECT id, categoryName FROM font_categories ORDER BY categoryName");
                                            foreach ($cats AS $cat)
                                            {
                                                echo "<option value=\"" . $cat['id'] . "\"";
                                                if (in_array($cat['id'], $font_categories))
                                                {
                                                    echo " SELECTED";
                                                }
                                                echo ">" . ($cat['categoryName']) . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label>Font Zip File:</label>
                                    <div class="input">
                                        <input name="font_file" id="font_file" type="file" class="xlarge validate[required]"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Font Designer</h3>
                            <p>Designer name, website url, profile url, blog url.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label for="font_designer">Font Designer:</label>
                                    <div class="input"><input id="font_designer" name="font_designer" type="text" class="xxlarge validate[required]" value="<?php echo adminFunctions::makeSafe($font_designer); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label for="url_website">Website Url:</label>
                                    <div class="input"><input id="url_website" name="url_website" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_website); ?>"/></div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label for="url_profile">Profile Url:</label>
                                    <div class="input"><input id="url_profile" name="url_profile" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_profile); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label for="url_blog">Blog Url:</label>
                                    <div class="input"><input id="url_blog" name="url_blog" type="text" class="xxlarge" value="<?php echo adminFunctions::makeSafe($url_blog); ?>"/></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Add Font" class="button blue">
                                    <input type="reset" value="Reset" class="button grey">
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<?php
include_once('_footer.inc.php');
?>