<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Manage Comments');
define('ADMIN_SELECTED_PAGE', 'comment_manage');

if (isset($_REQUEST['filterByStatus']))
{
    define('ADMIN_SELECTED_SUB_PAGE', 'comment_manage_pending');
}
else
{
    define('ADMIN_SELECTED_SUB_PAGE', 'comment_manage');
}

// includes and security
include_once('_local_auth.inc.php');

// page header
include_once('_header.inc.php');

// load all file status
$statusDetails = array('active', 'pending', 'spam');

// defaults
$filterText = '';
if (isset($_REQUEST['filterText']))
{
    $filterText = trim($_REQUEST['filterText']);
}

$filterByStatus = '';
if (isset($_REQUEST['filterByStatus']))
{
    $filterByStatus = $_REQUEST['filterByStatus'];
}

?>

<script>
    oTable = null;
    gCommentId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/comment_manage.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 2, "desc" ]],
            "aoColumns" : [   
                { bSortable: false, sWidth: '3%', sName: 'font_icon', sClass: "center adminResponsiveHide" },
                { sName: 'font_name', sWidth: '12%', sClass: "center adminResponsiveHide"},
                { sName: 'user_name', sWidth: '12%', sClass: "center adminResponsiveHide"},
                { sName: 'comment' },
                { sName: 'user_ip', sWidth: '12%', sClass: "center adminResponsiveHide" },
                { sName: 'date_created', sWidth: '12%', sClass: "center adminResponsiveHide" },
                { sName: 'status', sWidth: '10%', sClass: "center" },
                { bSortable: false, sWidth: '14%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                aoData.push( { "name": "filterByStatus", "value": $('#filterByStatus').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/comment_manage.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
        
        // dialog box
        $( "#confirmDelete" ).dialog({
            modal: true,
            autoOpen: false,
            width: getDefaultDialogWidth(),
            buttons: {
                "Delete Comment": function() {
                    removeComment();
                    $("#confirmDelete").dialog("close");
                },
                "Cancel": function() {
                    $("#confirmDelete").dialog("close");
                }
            },
            open: function() {
                resetOverlays();
            }
        });
    });

    function reloadTable()
    {
        oTable.fnDraw(false);
    }
    
    function confirmRemoveComment(commentId)
    {
        $('#confirmDelete').dialog('open');
        gCommentId = commentId;
    }
    
    function removeComment()
    {
        $.ajax({
            type: "POST",
            url: "ajax/delete_comment.ajax.php",
            data: { commentId: gCommentId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable(); 
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
    
    function approveComment(commentId)
    {
        $.ajax({
            type: "POST",
            url: "ajax/approve_comment.ajax.php",
            data: { commentId: commentId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable(); 
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
</script>

<div class="row clearfix">
    <div class="sectionLargeIcon largeFileIcon"></div>
    <div class="widget clearfix">
        <h2>Comment List</h2>
        <div class="widget_inside">
            <?php echo adminFunctions::compileNotifications(); ?>
            <div class="col_12">
                <table id='fileTable' class='dataTable'>
                    <thead>
                        <tr>
                            <th></th>
                            <th class="align-left"><?php echo adminFunctions::t('font_name', 'Font Name'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('user_name', 'User Name'); ?></th>
                            <th><?php echo adminFunctions::t('comment', 'Comment'); ?></th>
                            <th><?php echo adminFunctions::t('user_ip', 'User IP'); ?></th>
                            <th><?php echo adminFunctions::t('date_created', 'Date Created'); ?></th>
                            <th><?php echo adminFunctions::t('status', 'Status'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        Filter Results:
        <input name="filterText" id="filterText" type="text" value="<?php echo adminFunctions::makeSafe($filterText); ?>" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
    <label class="adminResponsiveHide" style="padding-left: 6px;">
        By Status:
        <select name="filterByStatus" id="filterByStatus" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($statusDetails))
            {
                foreach ($statusDetails AS $statusLabel)
                {
                    echo '<option value="' . $statusLabel . '"';
                    if ($filterByStatus == $statusLabel)
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords($statusLabel) . '</option>';
                }
            }
            ?>
        </select>
    </label>
</div>

<div id="confirmDelete" title="Confirm Action">
    <p>Are you sure you want to remove this comment? Once confirmed, the comment can not be recovered.</p>
</div>

<?php
include_once('_footer.inc.php');
?>