<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Manage Categories');
define('ADMIN_SELECTED_PAGE', 'category_manage');
define('ADMIN_SELECTED_SUB_PAGE', 'category_manage');

// includes and security
include_once('_local_auth.inc.php');

// page header
include_once('_header.inc.php');
?>

<script>
    oTable = null;
    gCategoryId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/category_manage.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 1, "asc" ]],
            "aoColumns" : [   
                { bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide" },
                { sName: 'category_name' },
                { sName: 'total_fonts', sWidth: '18%', sClass: "center adminResponsiveHide" },
                { bSortable: false, sWidth: '16%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/category_manage.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());

        // dialog box
        $( "#editCategoryForm" ).dialog({
            modal: true,
            autoOpen: false,
            width: getDefaultDialogWidth(),
            height: 330,
            buttons: {
                "Update": function() {
                    updateCategory();
                },
                "Cancel": function() {
                    $("#editCategoryForm").dialog("close");
                }
            },
            open: function() {
                setLoader();
                loadEditCategoryForm();
                resetOverlays();
            }
        });
        
        // dialog box
        $( "#confirmDelete" ).dialog({
            modal: true,
            autoOpen: false,
            width: getDefaultDialogWidth(),
            buttons: {
                "Delete Category": function() {
                    removeCategory();
                    $("#confirmDelete").dialog("close");
                },
                "Cancel": function() {
                    $("#confirmDelete").dialog("close");
                }
            },
            open: function() {
                resetOverlays();
            }
        });
    });
    
    function confirmRemoveCategory(categoryId)
    {
        $('#confirmDelete').dialog('open');
        gCategoryId = categoryId;
    }
    
    function removeCategory()
    {
        $.ajax({
            type: "POST",
            url: "ajax/delete_category.ajax.php",
            data: { categoryId: gCategoryId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable(); 
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
    
    function setLoader()
    {
        $('#categoryForm').html('Loading, please wait...');
    }
    
    function loadEditCategoryForm()
    {
        $.ajax({
            type: "POST",
            url: "ajax/category_manage_edit_form.ajax.php",
            data: { gCategoryId: gCategoryId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    $('#categoryForm').html(json.msg);
                }
                else
                {
                    $('#categoryForm').html(json.html);
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                $('#configurationForm').html(XMLHttpRequest.responseText);
            }
        });
    }
    
    function updateCategory()
    {
        // get data
        categoryId = $('#categoryIdElement').val();
        categoryName = $('#categoryNameElement').val();
        
        $.ajax({
            type: "POST",
            url: "ajax/category_manage_edit_process.ajax.php",
            data: { categoryId: categoryId, categoryName: categoryName },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg, 'popupMessageContainer');
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable();
                    $("#editCategoryForm").dialog("close");
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText, 'popupMessageContainer');
            }
        });

    }
    
    function editCategoryForm(categoryId)
    {
        gCategoryId = categoryId;
        $('#editCategoryForm').dialog('open');
    }
    
    function addCategoryForm()
    {
        gCategoryId = null;
        $('#editCategoryForm').dialog('open');
    }

    function reloadTable()
    {
        oTable.fnDraw(false);
    }
</script>

<div class="row clearfix">
    <div class="sectionLargeIcon largeConfigIcon"></div>
    <div class="widget clearfix">
        <h2>Manage Categories</h2>
        <div class="widget_inside">
            <?php echo adminFunctions::compileNotifications(); ?>
            <div class="col_12">
                <table id='fileTable' class='dataTable'>
                    <thead>
                        <tr>
                            <th></th>
                            <th class="align-left"><?php echo adminFunctions::t('category_name', 'Category Name'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('total_fonts', 'Total Fonts'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <input type="submit" value="Add Category" class="button blue" onClick="addCategoryForm(); return false;"/>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        Filter Results:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
</div>

<?php
include_once('_footer.inc.php');
?>

<div id="editCategoryForm" title="Category">
    <span id="categoryForm"></span>
</div>

<div id="confirmDelete" title="Confirm Action">
    <p>Are you sure you want to remove this category? Any fonts in this category will no longer be associated with it.</p>
</div>
