<?php

// includes and security
include_once('../_local_auth.inc.php');

$fontId = (int) $_REQUEST['fontId'];

// prepare result
$result = array();
$result['error'] = false;
$result['msg']   = '';

if (_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("no_changes_in_demo_mode");
}
else
{
    // load font
    $font = new font($fontId);
    if (!$font)
    {
        $result['error'] = true;
        $result['msg']   = 'Could not load font.';
    }
    else
    {
        if(isset($_REQUEST['approve']))
        {
            // approve
            $db->query("UPDATE font SET status='active' WHERE id = :fontId", array('fontId' => (int) $fontId));
            if ($db->affectedRows() == 1)
            {
                $result['error'] = false;
                $result['msg']   = 'Font \'' . $font->fontData['fontName'] . '\' approved.';
            }
            else
            {
                $result['error'] = true;
                $result['msg']   = 'Could not approve the font.';
            }
        }
        else
        {
            // remove font files
            if (is_dir(FONTS_PREVIEW_CACHE_FOLDER . (int) $fontId . '/'))
            {
                @htmlHelpers::deleteDir(FONTS_PREVIEW_CACHE_FOLDER . (int) $fontId . '/');
            }
            if (is_dir(FONTS_UNPACKED_ARCHIVE . (int) $fontId . '/'))
            {
                @htmlHelpers::deleteDir(FONTS_UNPACKED_ARCHIVE . (int) $fontId . '/');
            }
            $archive = FONTS_ARCHIVE_FOLDER . (int) $fontId . ".zip";
            if(file_exists($archive))
            {
                @unlink($archive);
            }

            // delete categories
            $db->query("DELETE FROM font_categories_join WHERE fontId = :fontId", array('fontId' => (int) $fontId));

            // remove font from db
            $db->query("DELETE FROM font WHERE id = :fontId", array('fontId' => (int) $fontId));
            if ($db->affectedRows() == 1)
            {
                $result['error'] = false;
                $result['msg']   = 'Font \'' . $font->fontData['fontName'] . '\' removed.';
            }
            else
            {
                $result['error'] = true;
                $result['msg']   = 'Could not remove the font.';
            }
        }
    }
}

echo json_encode($result);
exit;
