<?php

// includes and security
include_once('../_local_auth.inc.php');

$iDisplayLength     = (int) $_REQUEST['iDisplayLength'];
$iDisplayStart      = (int) $_REQUEST['iDisplayStart'];
$sSortDir_0         = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";
$filterText         = $_REQUEST['filterText'] ? $_REQUEST['filterText'] : "";
$filterByStatus     = strlen($_REQUEST['filterByStatus']) ? $_REQUEST['filterByStatus'] : false;
$filterByCategoryId = (int) $_REQUEST['filterByCategoryId'] ? (int) $_REQUEST['filterByCategoryId'] : 0;
$filterByUser = (int) $_REQUEST['filterByUser'] ? (int) $_REQUEST['filterByUser'] : 0;

// get sorting columns
$iSortCol_0     = (int) $_REQUEST['iSortCol_0'];
$sColumns       = trim($_REQUEST['sColumns']);
$arrCols        = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort           = 'fontName';
switch ($sortColumnName)
{
    case 'font_name':
        $sort = 'fontName';
        break;
    case 'font_designer':
        $sort = 'fontDesigner';
        break;
    case 'date_created':
        $sort = 'dateCreated';
        break;
    case 'status':
        $sort = 'status';
        break;
    case 'font_rating':
        $sort = 'fontRating';
        break;
    case 'total_downloads':
        $sort = 'totalDownloads';
        break;
}

$sqlClause = "WHERE 1=1 ";
if ($filterText)
{
    $filterText = $db->escape($filterText);
    $sqlClause .= "AND (font.status = '" . $filterText . "' OR ";
    $sqlClause .= "font.fontName LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font.fontDesigner LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font.id = '" . $filterText . "')";
}

if ($filterByStatus)
{
    $sqlClause .= " AND font.status = '" . $filterByStatus . "'";
}

if ($filterByCategoryId)
{
    $sqlClause .= " AND font.id IN (SELECT fontId FROM font_categories_join WHERE categoryId = " . $filterByCategoryId . ")";
}

if ($filterByUser > 0)
{
    $sqlClause .= " AND font.submittedUserId = ".$filterByUser;
}

$totalRS   = $db->getValue("SELECT COUNT(font.id) AS total FROM font " . $sqlClause);
$limitedRS = $db->getRows("SELECT * FROM font " . $sqlClause . " ORDER BY " . $sort . " " . $sSortDir_0 . " LIMIT " . $iDisplayStart . ", " . $iDisplayLength);

$data = array();
if (COUNT($limitedRS) > 0)
{
    foreach ($limitedRS AS $row)
    {
        $lRow = array();
        $icon = 'assets/images/icons/file_types/16px/' . $row['extension'] . '.png';
        if (!file_exists(ADMIN_ROOT . '/' . $icon))
        {
            $icon      = 'assets/images/icons/file_types/16px/_page.png';
        }
        $lRow[]    = '<img src="' . $icon . '" width="16" height="16" title="' . $row['fontName'] . '" alt="' . $row['fontName'] . '"/>';
        $lRow[]    = adminFunctions::makeSafe(adminFunctions::limitStringLength($row['fontName'], 35));
        $lRow[]    = adminFunctions::makeSafe($row['fontDesigner']);
        $lRow[]    = dater($row['dateCreated'], SITE_CONFIG_DATE_FORMAT);
        $lRow[]    = (int) $row['fontRating'];
        $lRow[]    = (int) $row['totalDownloads'];
        $statusRow = '<span class="statusText' . str_replace(" ", "", adminFunctions::makeSafe(UCWords($row['status']))) . '"';
        $statusRow .= '>' . $row['status'] . '</span>';
        $lRow[]    = $statusRow;

        $links = array();
        if($row['status'] == 'pending')
        {
            $links[] = '<a href="#" onClick="approveFont(' . (int) $row['id'] . '); return false;">approve</a>';
        }
        $links[] = '<a href="font_edit.php?id='.(int)$row['id'].'">edit</a>';
        $links[] = '<a href="#" onClick="confirmRemoveFont(' . (int) $row['id'] . '); return false;">delete</a>';
        $links[] = '<a href="' . font::createFontDetailsUrl($row['id'], $row['fontName']) . '" target="_blank">view</a>';
        $lRow[]  = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"]                = intval($_GET['sEcho']);
$resultArr["iTotalRecords"]        = (int) $totalRS;
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"]               = $data;

echo json_encode($resultArr);
