<?php

// includes and security
include_once('../_local_auth.inc.php');

$categoryId = (int) $_REQUEST['categoryId'];

// prepare result
$result = array();
$result['error'] = false;
$result['msg']   = '';

if (_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("no_changes_in_demo_mode");
}
else
{
    // remove category font joins from db
    $db->query("DELETE FROM font_categories_join WHERE categoryId = :categoryId", array('categoryId' => (int) $categoryId));
    
    // remove comment from db
    $db->query("DELETE FROM font_categories WHERE id = :categoryId", array('categoryId' => (int) $categoryId));
    if ($db->affectedRows() == 1)
    {
        $result['error'] = false;
        $result['msg']   = 'Category removed.';
    }
    else
    {
        $result['error'] = true;
        $result['msg']   = 'Could not remove the category.';
    }
}

echo json_encode($result);
exit;
