<?php

// includes and security
include_once('../_local_auth.inc.php');

$iDisplayLength = (int) $_REQUEST['iDisplayLength'];
$iDisplayStart  = (int) $_REQUEST['iDisplayStart'];
$sSortDir_0     = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";
$filterText     = $_REQUEST['filterText'] ? $_REQUEST['filterText'] : "";
$filterByStatus = strlen($_REQUEST['filterByStatus']) ? $_REQUEST['filterByStatus'] : false;

// get sorting columns
$iSortCol_0     = (int) $_REQUEST['iSortCol_0'];
$sColumns       = trim($_REQUEST['sColumns']);
$arrCols        = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort           = 'font.fontName';
switch ($sortColumnName)
{
    case 'font_name':
        $sort = 'font.fontName';
        break;
    case 'user_name':
        $sort = 'font_comment.userName';
        break;
    case 'comment':
        $sort = 'font_comment.comment';
        break;
    case 'user_ip':
        $sort = 'font_comment.userIP';
        break;
    case 'date_created':
        $sort = 'font_comment.dateCreated';
        break;
    case 'status':
        $sort = 'font_comment.status';
        break;
}

$sqlClause = "WHERE 1=1 ";
if ($filterText)
{
    $filterText = $db->escape($filterText);
    $sqlClause .= "AND (font.fontName LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font_comment.userName LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font_comment.comment LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font_comment.userIP LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font_comment.emailAddress LIKE '%" . $filterText . "%' OR ";
    $sqlClause .= "font.id = '" . $filterText . "')";
}

if ($filterByStatus)
{
    $sqlClause .= " AND font_comment.status = '" . $filterByStatus . "'";
}

$totalRS   = $db->getValue("SELECT COUNT(font_comment.id) AS total FROM font_comment LEFT JOIN font ON font_comment.fontId=font.id " . $sqlClause);
$limitedRS = $db->getRows("SELECT font.fontName AS fontName, font.id AS fontId, font_comment.* FROM font_comment LEFT JOIN font ON font_comment.fontId=font.id " . $sqlClause . " ORDER BY " . $sort . " " . $sSortDir_0 . " LIMIT " . $iDisplayStart . ", " . $iDisplayLength);

$data = array();
if (COUNT($limitedRS) > 0)
{
    foreach ($limitedRS AS $row)
    {
        $lRow = array();
        $icon = 'assets/images/icons/file_types/16px/' . $row['extension'] . '.png';
        if (!file_exists(ADMIN_ROOT . '/' . $icon))
        {
            $icon      = 'assets/images/icons/file_types/16px/_page.png';
        }
        $lRow[]    = '<img src="' . $icon . '" width="16" height="16" title="' . $row['fontName'] . '" alt="' . $row['fontName'] . '"/>';
        $lRow[]    = adminFunctions::makeSafe(adminFunctions::limitStringLength($row['fontName'], 35));
        $lRow[]    = "<span title='".adminFunctions::makeSafe($row['emailAddress'])."'>".adminFunctions::makeSafe($row['userName'])."</span>";
        $lRow[]    = adminFunctions::makeSafe($row['comment']);
        $lRow[]    = adminFunctions::makeSafe($row['userIP']);
        $lRow[]    = dater($row['dateCreated'], SITE_CONFIG_DATE_FORMAT);
        $statusRow = '<span class="statusText' . str_replace(" ", "", adminFunctions::makeSafe(UCWords($row['status']))) . '"';
        $statusRow .= '>' . $row['status'] . '</span>';
        $lRow[]    = $statusRow;

        $links = array();
        if($row['status'] == 'pending')
        {
            $links[] = '<a href="#" onClick="approveComment(' . (int) $row['id'] . '); return false;">approve</a>';
        }
        $links[] = '<a href="#" onClick="confirmRemoveComment(' . (int) $row['id'] . '); return false;">delete</a>';
        $links[] = '<a href="'.font::createFontDetailsUrl($row['fontId'], $row['fontName']).'" target="_blank">font</a>';
        $lRow[]  = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"]                = intval($_GET['sEcho']);
$resultArr["iTotalRecords"]        = (int) $totalRS;
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"]               = $data;

echo json_encode($resultArr);
